# IMPETUS User Material Models Framework

### Documentation
Documentation in the `docs` folder.

### Source code

Framework source code is located in the `user-material` folder.

### Examples

Examples of IMPETUS simulation models using the provided material models can be found in the `example-models` folder.

### Tree

```
├── CMakeLists.txt
├── LICENSE.txt
├── Makefile
├── README.md
├── docs
├── example-models
│   ├── metal-tensile
│   └── rubber-slingshot
│       └── main.k
├── output
├── user-material
│   ├── gpu_error.cpp
│   ├── gpu_error.h
│   ├── interface.cpp
│   ├── interface.h
│   ├── kernel_mat_concrete.cu
│   ├── kernel_mat_concrete.h
│   ├── kernel_mat_metal.cu
│   ├── kernel_mat_metal.h
│   ├── kernel_mat_orthotropic.cu
│   ├── kernel_mat_orthotropic.h
│   ├── kernel_mat_rubber.cu
│   ├── kernel_mat_rubber.h
│   ├── mat_concrete.cpp
│   ├── mat_concrete.h
│   ├── mat_metal.cpp
│   ├── mat_metal.h
│   ├── mat_orthotropic.cpp
│   ├── mat_orthotropic.h
│   ├── mat_rubber.cpp
│   ├── mat_rubber.h
│   ├── mat_user.h
│   ├── mat_user_defines.h
│   ├── mat_user_functions.h
│   ├── mat_user_structs_cpu.h
│   ├── mat_user_structs_gpu.h
│   ├── user-material.vcxproj
│   └── user-material.vcxproj.filters
└── user-material.sln
```