// fortran.js
hljs.registerLanguage('fortran', function(hljs) {
    return {
        case_insensitive: true,
        keywords: {
            keyword: 'program end subroutine function module use include implicit none type integer real double precision complex logical character kind if then else end if endif select case end select case endcase selecttype end selecttype ' +
                     'do end do enddo while end while endwhile continue stop return call open close read write print format rewind backspace endfile inquire flush allocate deallocate pause data common equivalence block data namelist save ' +
                     'dimension external intrinsic parameter public private sequence contains intent optional target pointer allocatable automatic intrinsic volatile ' +
                     'interface procedure operator assignment end interface abstract extends class associate block change team critical end critical critical_construct end team end team_construct enum enumerator end enum enum_class bind generic ' +
                     'where elsewhere end where elemental pure impure recursive non_recursive submodule end submodule procedure procedure_pointer end procedure_pointer ' +
                     'goto end goto exit cycle nopass pass volatile value result entry ' +
                     'select rank select type class parent end select rank default ' +
                     'forall end forall atomic_define atomic_read lock unlock sync images ' +
                     'team split ' +
                     'codimension critical error stop do concurrent ' +
                     'forall sync images sync memory ' +
                     'sync team ' +
                     'sync all ' +
                     'change team lock lock ' +
                     'unlock unlock ' +
                     'call lock call unlock ' +
                     'critical critical ' +
                     'end critical ' +
                     'critical critical_construct ' +
                     'error stop ' +
                     'where where_construct elsewhere',
            literal: '.false. .true. null',
            built_in: 'abs acos aimag aint all allocated anint any asin associated atan bit_size btest ceiling cmplx conjg cos cosh count cshift dble digits dim dot_product dprod dshiftl dshiftr eoshift epsilon erf erfc exp exponent floor fraction ' +
                      'huge iand ibclr ibits ibset ichar ieor ior ishft ishftc lbound len len_trim lge lgt lle llt log log10 matmul max maxexponent maxloc maxval merge min minexponent minloc minval mod modulo mvbits nearest nint not nullify pack present product ' +
                      'radix random_number random_seed range real repeat reshape rrspacing scale scan selected_int_kind selected_real_kind set_exponent shape sign sin sinh size sqrt sum tan tanh tiny transfer transpose trim ubound unpack verify',
        },
        contains: [
            {
                className: 'comment',
                begin: '!',
                end: '$'
            },
            {
                className: 'string',
                begin: "'", end: "'",
                contains: [hljs.BACKSLASH_ESCAPE]
            },
            {
                className: 'string',
                begin: '"', end: '"',
                contains: [hljs.BACKSLASH_ESCAPE]
            },
            {
                className: 'number',
                begin: '(\\b(\\d+(\\.\\d*)?|\\.\\d+)([de][-+]?\\d+)?(_[a-zA-Z]\\w*)?)',
                relevance: 0
            },
            {
                className: 'number',
                begin: '(\\b\\d+)',
                relevance: 0
            }
        ]
    };
});

// Attach this to mdBook in your book.toml
hljs.initHighlightingOnLoad();
