Object.assign(window.search, {"doc_urls":["introduction.html#introduction","introduction.html#licence","getting-started/installation.html#installation","getting-started/installation.html#prerequisites","getting-started/structure.html#structure","getting-started/compilation.html#compilation","getting-started/compilation.html#windows","getting-started/compilation.html#linux","getting-started/usage.html#usage","getting-started/usage.html#start-simulation-with-your-dll--shared-object-in-the-gui","getting-started/usage.html#start-simulation-with-your-dll--shared-object-in-cli","interface/overview/index.html#overview","interface/overview/mat-user-class.html#matuser-class","interface/overview/mat-user-class.html#configuration","interface/overview/mat-user-class.html#virtual-functions-to-override","interface/overview/interface.html#material-model-interface","interface/overview/interface.html#overview-of-interface-functions","interface/overview/interface.html#implementing-your-own-user-material","interface/overview/interface.html#example-use-case","interface/overview/namespaces.html#namespaces","interface/overview/tensor-matrix.html#tensor-and-matrix-order","interface/overview/tensor-matrix.html#tensor-notation","interface/overview/tensor-matrix.html#matrix-access-order","interface/config/index.html#material-configuration","interface/config/material-prop.html#material-properties","interface/config/material-prop.html#class-member-variables","interface/config/material-prop.html#description","interface/config/stiffness-prop.html#stiffness-properties","interface/config/stiffness-prop.html#class-member-variables","interface/config/stiffness-prop.html#description","interface/config/damage-prop.html#damage-properties","interface/config/damage-prop.html#class-member-variables","interface/config/damage-prop.html#description","interface/config/example.html#example","interface/config/example.html#mat_metalcpp","interface/init/index.html#material-initialization","interface/init/index.html#runinit","interface/init/index.html#example","interface/response/index.html#material-response","interface/response/cpu.html#cpu-implementation","interface/response/cpu.html#runmat","interface/response/cpu.html#example","interface/response/cpu-memory.html#cpu-memory-access","interface/response/cpu-access-pattern.html#data-access-pattern","interface/response/gpu.html#gpu-implementation","interface/response/gpu.html#runmatgpu","interface/response/gpu.html#example","interface/response/cuda.html#cuda-programming-model","interface/response/cuda.html#kernels","interface/response/cuda.html#functions","interface/response/cuda.html#example","interface/response/cuda.html#more-information","interface/response/cuda-files.html#cuda-kernel-files","interface/response/cuda-files.html#kernel_mat_xxxxh","interface/response/cuda-files.html#kernel_mat_xxxxcu","interface/response/kernel-launch.html#cuda-kernel-launch","interface/response/kernel-launch.html#mat_user","interface/response/cuda-thread-id.html#thread-identifier","interface/response/cuda-thread-id.html#compute-a-unique-index","interface/response/cuda-thread-id.html#preventing-out-of-bounds-access","interface/response/gpu-memory.html#memory-access","interface/response/gpu-memory.html#general-memory-access-guidelines","interface/response/gpu-memory.html#further-reading","interface/response/gpu-access-pattern.html#data-access-pattern","interface/response/gpu-access-pattern.html#per-thread-arrays","interface/response/gpu-access-pattern.html#per-thread-tensor-arrays","interface/response/gpu-access-pattern.html#per-thread-state-variable-arrays","interface/response/gpu-access-pattern.html#per-thread-3x3-matrix-arrays","interface/response/gpu-access-pattern.html#subgroup-shared-array-element-level","interface/response/gpu-access-pattern.html#curve-arrays","interface/response/prop-coupling.html#property-coupling","interface/config/damage-prop.html#damage-properties","interface/config/damage-prop.html#class-member-variables","interface/config/damage-prop.html#description","interface/response/thermal-id.html#use-of-thermal-property","interface/response/thermal-id.html#c","interface/response/thermal-id.html#cuda","interface/response/eos-id.html#use-of-equation-of-state","interface/response/eos-id.html#gpu","interface/response/eos-id.html#cpu","interface/response/examples.html#examples","interface/response/examples.html#metal-","interface/response/examples.html#concrete","interface/response/examples.html#rubber","interface/response/examples.html#orthotropic","api/index.html#c-api","api/error-check.html#error-check","api/structs.html#data-structures","api/struct-data-cpu.html#usermatcpu","api/struct-data-cpu.html#structure","api/struct-data-cpu.html#variables","api/struct-data-init-cpu.html#usermatinitcpu","api/struct-data-init-cpu.html#structure","api/struct-data-init-cpu.html#variables","api/struct-data-device.html#usermatdevice","api/struct-data-device.html#structure","api/struct-data-device.html#variables","api/struct-data-host.html#usermathost","api/struct-data-host.html#structure","api/struct-data-host.html#variables","api/cpp-cuda.html#c--cuda-api","api/cauchy-tensor.html#cauchy-green-tensor","api/cauchy-tensor.html#parameters","api/cross-product.html#cross-product","api/cross-product.html#parameters","api/eff-strain-rate.html#effective-strain-rate","api/eff-strain-rate.html#parameters","api/eff-strain-rate.html#returns","api/eff-stress.html#effective-stress","api/eff-stress.html#parameters","api/eff-stress.html#returns","api/eigenvalues.html#eigenvalues","api/eigenvalues.html#parameters","api/eigenvectors.html#eigenvectors","api/eigenvectors.html#parameters","api/invert-3x3.html#invert-3x3-matrix","api/invert-3x3.html#parameters","api/invert-3x3.html#returns","api/load-curve.html#load-curve--function","api/load-curve.html#parameters","api/load-curve.html#returns","api/transform-tensor.html#transform-tensor","api/transform-tensor.html#parameters","api/von-mises-1.html#von-mises-step-1","api/von-mises-1.html#parameters","api/von-mises-2.html#von-mises-step-2","api/von-mises-2.html#parameters"],"index":{"documentStore":{"docInfo":{"0":{"body":101,"breadcrumbs":2,"title":1},"1":{"body":101,"breadcrumbs":2,"title":1},"10":{"body":52,"breadcrumbs":7,"title":6},"100":{"body":36,"breadcrumbs":6,"title":3},"101":{"body":25,"breadcrumbs":9,"title":3},"102":{"body":9,"breadcrumbs":7,"title":1},"103":{"body":21,"breadcrumbs":7,"title":2},"104":{"body":12,"breadcrumbs":6,"title":1},"105":{"body":15,"breadcrumbs":9,"title":3},"106":{"body":5,"breadcrumbs":7,"title":1},"107":{"body":3,"breadcrumbs":7,"title":1},"108":{"body":14,"breadcrumbs":7,"title":2},"109":{"body":4,"breadcrumbs":6,"title":1},"11":{"body":62,"breadcrumbs":2,"title":1},"110":{"body":2,"breadcrumbs":6,"title":1},"111":{"body":19,"breadcrumbs":5,"title":1},"112":{"body":10,"breadcrumbs":5,"title":1},"113":{"body":23,"breadcrumbs":5,"title":1},"114":{"body":15,"breadcrumbs":5,"title":1},"115":{"body":14,"breadcrumbs":9,"title":3},"116":{"body":22,"breadcrumbs":7,"title":1},"117":{"body":3,"breadcrumbs":7,"title":1},"118":{"body":23,"breadcrumbs":9,"title":3},"119":{"body":21,"breadcrumbs":7,"title":1},"12":{"body":49,"breadcrumbs":5,"title":2},"120":{"body":3,"breadcrumbs":7,"title":1},"121":{"body":29,"breadcrumbs":7,"title":2},"122":{"body":12,"breadcrumbs":6,"title":1},"123":{"body":25,"breadcrumbs":11,"title":4},"124":{"body":25,"breadcrumbs":8,"title":1},"125":{"body":29,"breadcrumbs":11,"title":4},"126":{"body":35,"breadcrumbs":8,"title":1},"13":{"body":23,"breadcrumbs":4,"title":1},"14":{"body":119,"breadcrumbs":6,"title":3},"15":{"body":15,"breadcrumbs":7,"title":3},"16":{"body":37,"breadcrumbs":7,"title":3},"17":{"body":22,"breadcrumbs":7,"title":3},"18":{"body":63,"breadcrumbs":7,"title":3},"19":{"body":134,"breadcrumbs":3,"title":1},"2":{"body":14,"breadcrumbs":2,"title":1},"20":{"body":0,"breadcrumbs":7,"title":3},"21":{"body":41,"breadcrumbs":6,"title":2},"22":{"body":27,"breadcrumbs":7,"title":3},"23":{"body":43,"breadcrumbs":4,"title":2},"24":{"body":0,"breadcrumbs":6,"title":2},"25":{"body":21,"breadcrumbs":7,"title":3},"26":{"body":206,"breadcrumbs":5,"title":1},"27":{"body":70,"breadcrumbs":6,"title":2},"28":{"body":8,"breadcrumbs":7,"title":3},"29":{"body":119,"breadcrumbs":5,"title":1},"3":{"body":25,"breadcrumbs":2,"title":1},"30":{"body":46,"breadcrumbs":6,"title":2},"31":{"body":14,"breadcrumbs":7,"title":3},"32":{"body":49,"breadcrumbs":5,"title":1},"33":{"body":0,"breadcrumbs":4,"title":1},"34":{"body":121,"breadcrumbs":4,"title":1},"35":{"body":38,"breadcrumbs":4,"title":2},"36":{"body":19,"breadcrumbs":3,"title":1},"37":{"body":64,"breadcrumbs":3,"title":1},"38":{"body":40,"breadcrumbs":4,"title":2},"39":{"body":22,"breadcrumbs":6,"title":2},"4":{"body":107,"breadcrumbs":2,"title":1},"40":{"body":18,"breadcrumbs":5,"title":1},"41":{"body":187,"breadcrumbs":5,"title":1},"42":{"body":46,"breadcrumbs":9,"title":3},"43":{"body":30,"breadcrumbs":10,"title":3},"44":{"body":50,"breadcrumbs":6,"title":2},"45":{"body":48,"breadcrumbs":5,"title":1},"46":{"body":35,"breadcrumbs":5,"title":1},"47":{"body":0,"breadcrumbs":10,"title":3},"48":{"body":23,"breadcrumbs":8,"title":1},"49":{"body":28,"breadcrumbs":8,"title":1},"5":{"body":0,"breadcrumbs":2,"title":1},"50":{"body":29,"breadcrumbs":8,"title":1},"51":{"body":20,"breadcrumbs":9,"title":2},"52":{"body":43,"breadcrumbs":10,"title":3},"53":{"body":21,"breadcrumbs":8,"title":1},"54":{"body":82,"breadcrumbs":8,"title":1},"55":{"body":0,"breadcrumbs":10,"title":3},"56":{"body":298,"breadcrumbs":8,"title":1},"57":{"body":82,"breadcrumbs":8,"title":2},"58":{"body":24,"breadcrumbs":9,"title":3},"59":{"body":52,"breadcrumbs":10,"title":4},"6":{"body":84,"breadcrumbs":2,"title":1},"60":{"body":0,"breadcrumbs":8,"title":2},"61":{"body":127,"breadcrumbs":10,"title":4},"62":{"body":15,"breadcrumbs":8,"title":2},"63":{"body":15,"breadcrumbs":10,"title":3},"64":{"body":21,"breadcrumbs":10,"title":3},"65":{"body":40,"breadcrumbs":11,"title":4},"66":{"body":35,"breadcrumbs":12,"title":5},"67":{"body":40,"breadcrumbs":12,"title":5},"68":{"body":19,"breadcrumbs":12,"title":5},"69":{"body":20,"breadcrumbs":9,"title":2},"7":{"body":68,"breadcrumbs":2,"title":1},"70":{"body":11,"breadcrumbs":6,"title":2},"71":{"body":46,"breadcrumbs":9,"title":2},"72":{"body":14,"breadcrumbs":10,"title":3},"73":{"body":49,"breadcrumbs":8,"title":1},"74":{"body":19,"breadcrumbs":10,"title":3},"75":{"body":30,"breadcrumbs":8,"title":1},"76":{"body":41,"breadcrumbs":8,"title":1},"77":{"body":13,"breadcrumbs":10,"title":3},"78":{"body":48,"breadcrumbs":8,"title":1},"79":{"body":10,"breadcrumbs":8,"title":1},"8":{"body":17,"breadcrumbs":2,"title":1},"80":{"body":7,"breadcrumbs":2,"title":1},"81":{"body":42,"breadcrumbs":2,"title":1},"82":{"body":46,"breadcrumbs":2,"title":1},"83":{"body":35,"breadcrumbs":2,"title":1},"84":{"body":52,"breadcrumbs":2,"title":1},"85":{"body":8,"breadcrumbs":4,"title":2},"86":{"body":41,"breadcrumbs":6,"title":2},"87":{"body":11,"breadcrumbs":6,"title":2},"88":{"body":0,"breadcrumbs":6,"title":1},"89":{"body":50,"breadcrumbs":6,"title":1},"9":{"body":31,"breadcrumbs":7,"title":6},"90":{"body":166,"breadcrumbs":6,"title":1},"91":{"body":0,"breadcrumbs":6,"title":1},"92":{"body":30,"breadcrumbs":6,"title":1},"93":{"body":110,"breadcrumbs":6,"title":1},"94":{"body":0,"breadcrumbs":6,"title":1},"95":{"body":52,"breadcrumbs":6,"title":1},"96":{"body":266,"breadcrumbs":6,"title":1},"97":{"body":0,"breadcrumbs":6,"title":1},"98":{"body":2,"breadcrumbs":6,"title":1},"99":{"body":6,"breadcrumbs":6,"title":1}},"docs":{"0":{"body":"IMPETUS Solver provides a framework for custom material models through dynamic-link library (DLL) or shared object files under Linux. Users can compile their own user-defined materials, which are then linked to the software at the start of a simulation. This approach offers several advantages, including seamless compatibility with any version of the software, provided there have been no major changes to the interface. Users can take advantage of the latest software updates without requiring significant modifications to their custom material models. By incorporating specialized knowledge and expertise into their simulations, users can leverage proprietary material properties or complex constitutive relationships that may not be readily available in standard material models. The ability to link up to eight user-defined material models also provides flexibility in modeling complex systems comprising diverse materials. This feature enables users to tailor the solver's behavior to meet specific simulation requirements, thereby increasing its overall utility and effectiveness.","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"This IMPETUS User material package and documentation are released under the MIT License . MIT License Copyright (c) 2024 IMPETUS Permission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software. THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.","breadcrumbs":"Introduction » Licence","id":"1","title":"Licence"},"10":{"body":"To start simulations in CLI, use the impstart command, which is located in [installation_dir]/Solver/gui. This tool add simulations to the job queue and status can be seen in the Solve tab of IMPETUS Solver GUI. Usage impstart [options] INPUTFILE Impstart is a command line tool and its options are obtained by executing it without arguments. Use the --material-path option to specify where to find the material DLL / shared object file. Example impstart --material-path /path/to/user-material.so /path/to/input-file.k","breadcrumbs":"Usage » Start simulation with your DLL / shared object in CLI","id":"10","title":"Start simulation with your DLL / shared object in CLI"},"100":{"body":"These built-in APIs provide pre-defined functions for performing mathematical and material-related tasks. All functions are declared as both __host__ and __device__, which means they will work on both C++ and CUDA. Implementation of the functions are in mat_user_functions.h and are part of the mat namespace. To use them, prepend mat:: before each function. double sig_eff = mat::mat_effective_stress(stress);","breadcrumbs":"C++ / CUDA API » C++ / CUDA API","id":"100","title":"C++ / CUDA API"},"101":{"body":"The Cauchy-Green tensor describes the deformation of a material body, playing a key role in nonlinear elasticity and finite deformations. template <typename T>\ninline __host__ __device__ void cauchy_green_tensor(T* mat, T* c)","breadcrumbs":"C++ / CUDA API » Cauchy-Green tensor » Cauchy-Green tensor","id":"101","title":"Cauchy-Green tensor"},"102":{"body":"mat Input: 3x3 matrix c Output: C (symmetric tensor)","breadcrumbs":"C++ / CUDA API » Cauchy-Green tensor » Parameters","id":"102","title":"Parameters"},"103":{"body":"This function will return the cross product between a1 & a2 in a3. template <typename T>\ninline __host__ __device__ void cross_product(T* a1, T* a2, T* a3)","breadcrumbs":"C++ / CUDA API » Cross product » Cross product","id":"103","title":"Cross product"},"104":{"body":"a1 Input: vector 1 a2 Input: vector 2 a3 Output: vector 3","breadcrumbs":"C++ / CUDA API » Cross product » Parameters","id":"104","title":"Parameters"},"105":{"body":"This function calculates and returns the effective strain rate. template <typename T>\ninline __host__ __device__ T mat_effective_strain_rate(T* strain_rate)","breadcrumbs":"C++ / CUDA API » Effective strain rate » Effective strain rate","id":"105","title":"Effective strain rate"},"106":{"body":"strain_rate Input: Strain rate tensor","breadcrumbs":"C++ / CUDA API » Effective strain rate » Parameters","id":"106","title":"Parameters"},"107":{"body":"Effective strain rate","breadcrumbs":"C++ / CUDA API » Effective strain rate » Returns","id":"107","title":"Returns"},"108":{"body":"This function calculates and returns the effective stress. template <typename T>\ninline __host__ __device__ T mat_effective_stress(T* strain_rate)","breadcrumbs":"C++ / CUDA API » Effective stress » Effective stress","id":"108","title":"Effective stress"},"109":{"body":"stress Input: Stress tensor","breadcrumbs":"C++ / CUDA API » Effective stress » Parameters","id":"109","title":"Parameters"},"11":{"body":"Our user-defined material models framework is built on a C++ architecture, making it easy for users to develop their own custom material models. The framework provides a seamless interface for implementing materials behavior that is thoroughly integrated into the software. Our framework also incorporates a GPU-accelerated implementation that leverages Nvidia's CUDA architecture. By offloading computationally intensive material model to the GPU, users can achieve substantial speedups over traditional CPU-based implementations. Our CUDA interface is easy to use and enables users to simulate complex material behavior at unprecedented scales and speeds.","breadcrumbs":"Overview » Overview","id":"11","title":"Overview"},"110":{"body":"Effective stress","breadcrumbs":"C++ / CUDA API » Effective stress » Returns","id":"110","title":"Returns"},"111":{"body":"This function calculates and returns the eigenvalues eval of the input tensor s. template <typename T>\ninline __host__ __device__ void calc_eigen_values(T* s, T* eval)","breadcrumbs":"C++ / CUDA API » Eigenvalues » Eigenvalues","id":"111","title":"Eigenvalues"},"112":{"body":"s Input: Tensor to be decomposed into eigenvalues eval Output: Eigenvalues of the input tensor","breadcrumbs":"C++ / CUDA API » Eigenvalues » Parameters","id":"112","title":"Parameters"},"113":{"body":"This function calculates and returns the eigenvectors evec of the input tensor s and its eigenvalues eval. template <typename T>\ninline __host__ __device__ void calc_eigen_vectors(T* s, T* eval, T* evec)","breadcrumbs":"C++ / CUDA API » Eigenvectors » Eigenvectors","id":"113","title":"Eigenvectors"},"114":{"body":"s Input: Tensor to be decomposed into eigenvalues eval Input: Eigenvalues of the input tensor eval Output: Eigenvectors of the input tensor","breadcrumbs":"C++ / CUDA API » Eigenvectors » Parameters","id":"114","title":"Parameters"},"115":{"body":"Invert a 3x3 matrix. template <typename T>\ninline __host__ __device__ double invert_3x3(T* mat, T* mat_inv)","breadcrumbs":"C++ / CUDA API » Invert 3x3 matrix » Invert 3x3 matrix","id":"115","title":"Invert 3x3 matrix"},"116":{"body":"mat Input: 9-component 1D (3x3 matrix) in column major order mat_inv Output: 9-component 1D (3x3 matrix) inverted matrix in column major order","breadcrumbs":"C++ / CUDA API » Invert 3x3 matrix » Parameters","id":"116","title":"Parameters"},"117":{"body":"Determinate of the input matrix.","breadcrumbs":"C++ / CUDA API » Invert 3x3 matrix » Returns","id":"117","title":"Returns"},"118":{"body":"Returns the ordinate value of x in the defined id. template <typename T1, typename T2>\ninline __host__ __device__ double load_curve(T1* curve_data, T2* curve_val, int id, double x)","breadcrumbs":"C++ / CUDA API » Load Curve / Function » Load Curve / Function","id":"118","title":"Load Curve / Function"},"119":{"body":"curve_data Input: Array of curve data curve_val Input: Array of curve values id Input: Function or Curve ID x Input: Value of x in function f(x)","breadcrumbs":"C++ / CUDA API » Load Curve / Function » Parameters","id":"119","title":"Parameters"},"12":{"body":"To create your own custom material model using our framework, derive a new class from the MatUser base class, which serves as a foundation for defining user-defined materials. The MatUser class provides a basic structure through its virtual functions, enabling you to override and customize the behavior of your material model. To get started, create a new C++ class that inherits from MatUser. For example: #include \"mat_user.h\" class MatMyModel : public MatUser { // Your implementation goes here...\n};","breadcrumbs":"Overview » MatUser class » MatUser class","id":"12","title":"MatUser class"},"120":{"body":"The ordinate value of x.","breadcrumbs":"C++ / CUDA API » Load Curve / Function » Returns","id":"120","title":"Returns"},"121":{"body":"Transform tensor to a fiber direction. template <typename T, int transpose>\ninline __host__ __device__ void transform_tensor(T* s, T* r, T* b) Note: This function requires specification of the template parameter typename T and int transpose.","breadcrumbs":"C++ / CUDA API » Transform tensor » Transform tensor","id":"121","title":"Transform tensor"},"122":{"body":"s Input: Tensor to be transformed r Input: fiber direction b Output: Transformed tensor","breadcrumbs":"C++ / CUDA API » Transform tensor » Parameters","id":"122","title":"Parameters"},"123":{"body":"von Mises yield criterion (step 1) template <typename T>\ninline __host__ __device__ void mat_yield_von_mises_1(T shear, T sigy0, T* sig_eff, T* stress, T* deps, int* yield)","breadcrumbs":"C++ / CUDA API » von Mises (step 1) » von Mises (step 1)","id":"123","title":"von Mises (step 1)"},"124":{"body":"shear Input: Shear sigy0 Input: Current yield stress sig_eff Output: Effective stress stress Input: Stress tensor deps Output: Strain increment yield Output: Flag to indicate if we have plasticity or not","breadcrumbs":"C++ / CUDA API » von Mises (step 1) » Parameters","id":"124","title":"Parameters"},"125":{"body":"von Mises yield criterion (step 2) template <typename T>\ninline __host__ __device__ void mat_yield_von_mises_2(T shear, T sigy0, T sigy1, T* sig_eff, T* stress, T* deps, T* epsp, T* depsp)","breadcrumbs":"C++ / CUDA API » von Mises (step 2) » von Mises (step 2)","id":"125","title":"von Mises (step 2)"},"126":{"body":"shear Input: Shear sigy0 Input: Current yield stress sigy1 Input: Yield stress at strain increment sig_eff Output: Effective stress stress Input: Stress tensor deps Output: Strain increment epsp Output: Effective plastic strain depsp Output: Strain incremment","breadcrumbs":"C++ / CUDA API » von Mises (step 2) » Parameters","id":"126","title":"Parameters"},"13":{"body":"Each material must define its material configuration. This is done by setting the class member variables in the constructor of your material model class. See Material configuration section for more information on how to configure a material model.","breadcrumbs":"Overview » MatUser class » Configuration","id":"13","title":"Configuration"},"14":{"body":"void runInit(UserMatInitCPU data) const This function is invoked during the initialization phase of the simulation. You can use it to set up any necessary data structures or perform other initialization tasks, such as set the inital state of the material and, if required, calculate material parameters. void runMat(UserMatCPU data) const This function is executed each time step of the simulation if GPU acceleration in not available /enabled. It is effectively defining the behavior of the material. The constitutive response, failure criteria, and post-failure behavior are all critical components that can be tailored to capture the unique characteristics of various materials. void runInitGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const Currently not used, reserved for future implementation void runMatGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const This is similar to runCPU but for GPU accelerated computation. Unlike the CPU-based executions, where member functions can be directly defined within the class structure, CUDA kernel implementations must reside in separate files due to the language's inherent limitations. As a result, this function acts as an interface, invoking the relevant GPU-accelerated implementation from the external file.","breadcrumbs":"Overview » MatUser class » Virtual functions to override","id":"14","title":"Virtual functions to override"},"15":{"body":"The material model interface is a set of C functions that are used to configure, initialize and run a material model. These functions are implemented in interface.cpp.","breadcrumbs":"Overview » Material model interface » Material model interface","id":"15","title":"Material model interface"},"16":{"body":"Each user material consists of five functions, which are all called by IMPETUS Solver: mat_user_X_config: Get the configuration parameters required for the material model. init_mat_user_X: Initializes the material state. mat_user_X: Evaluates the material response. init_mat_user_X_gpu: Currently not being used, but reserved for future GPU implementation. mat_user_X_gpu: Evaluates the material behavior on a GPU device.","breadcrumbs":"Overview » Material model interface » Overview of interface functions","id":"16","title":"Overview of interface functions"},"17":{"body":"Create an instance of your derived MatUser class. Choose an available slot (e.g., mat_user_1). Link the the following functions with your material model's corresponding functions: mat_user_X_config init_mat_user_X mat_user_X init_mat_user_X_gpu mat_user_X_gpu","breadcrumbs":"Overview » Material model interface » Implementing Your Own User Material","id":"17","title":"Implementing Your Own User Material"},"18":{"body":"Suppose you want to link your user material (e.g. MatMetal). You would: Create an instance of MatMetal class (don't forget the namespace). Choose slot mat_user_1. Link each of the functions for this material ID with its corresponding class functions: static user_metal::MatMetal metal; void mat_user_1_config(UserMatConfig* config, UserMatProp* properties)\n{ metal.getConfig(config, properties);\n} void init_mat_user_1(UserMatInitCPU data)\n{ metal.runInit(data);\n} void mat_user_1(UserMatCPU data)\n{ metal.runMat(data);\n} void init_mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)\n{ metal.runInitGPU(host, device, stream);\n} void mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)\n{ metal.runMatGPU(host, device, stream);\n}","breadcrumbs":"Overview » Material model interface » Example Use Case","id":"18","title":"Example Use Case"},"19":{"body":"Namespaces allow us to use the same name for different functions or variables in different contexts without causing ambiguity. For example, consider two material models: metal and rubber. Both may have a function named execute. Without namespaces, defining these functions with the same name in a global scope would lead to a naming conflict. By placing execute within respective namespaces, we can easily tell them apart. Namespaces are a powerful tool that enables us to define multiple functions or variables with the same name without causing ambiguity. This is particularly useful when working with different material models, such as metal and rubber, which may share common functionality but require distinct implementations. For instance, consider two material models: mat_metal and mat_rubber, each of which might have a function named execute. Without namespaces, defining these functions in the global scope would result in a naming conflict, and compilation errors. By placing the execute function within its respective namespace, we can easily differentiate between the two implementations. This not only improves code organization and maintainability but also reduces the likelihood of bugs and errors. namespace user_metal\n{ void execute() { }\n} // namespace user_metal namespace user_rubber\n{ void execute() { }\n} // namespace user_rubber int function()\n{ // Call metal execution user_metal::execute(); // Call rubber execution user_rubber::execute();\n}","breadcrumbs":"Overview » Namespaces » Namespaces","id":"19","title":"Namespaces"},"2":{"body":"To compile and build this framework, you need to have the necessary compilation tools installed. This includes standard compilers for the languages used in the framework.","breadcrumbs":"Installation » Installation","id":"2","title":"Installation"},"20":{"body":"","breadcrumbs":"Overview » Tensor and Matrix order » Tensor and Matrix order","id":"20","title":"Tensor and Matrix order"},"21":{"body":"All symmetric tensors in IMPETUS Solver uses an alternative notation of the Voigt notation . \\( \\begin{bmatrix} \\sigma_{1} & \\sigma_{6} & \\sigma_{5} \\\\ & \\sigma_{2} & \\sigma_{4} \\\\ & & \\sigma_{3} \\end{bmatrix} \\) Traditional voigt notation: 11, 22, 33, 23, 13, 12. \\( \\begin{bmatrix} \\sigma_{1} & \\sigma_{4} & \\sigma_{6} \\\\ & \\sigma_{2} & \\sigma_{5} \\\\ & & \\sigma_{3} \\end{bmatrix} \\) Our definition is: 11, 22, 33, 12, 23, 13.","breadcrumbs":"Overview » Tensor and Matrix order » Tensor Notation","id":"21","title":"Tensor Notation"},"22":{"body":"Matrices are stored in column major order . \\( \\begin{bmatrix} \\sigma_{11} & \\sigma_{12} & \\sigma_{13} \\\\ \\sigma_{21} & \\sigma_{22} & \\sigma_{23} \\\\ \\sigma_{31} & \\sigma_{32} & \\sigma_{33} \\end{bmatrix} \\) The order of the matrix is: 11, 21, 31, 12, 22, 32, 13, 23, 33","breadcrumbs":"Overview » Tensor and Matrix order » Matrix access order","id":"22","title":"Matrix access order"},"23":{"body":"To properly configure each material, you must implement its properties. This is achieved through the constructor of your material model class, where you can set the relevant class member variables. The following sections will provide detailed information on the parameters that need to be configured for each material. By following these guidelines and setting the required parameters in the constructor of your material model class, you can ensure that each material is accurately represented and prepared for simulation.","breadcrumbs":"Material configuration » Material configuration","id":"23","title":"Material configuration"},"24":{"body":"","breadcrumbs":"Material configuration » Material properties » Material properties","id":"24","title":"Material properties"},"25":{"body":"bool gpu_enabled;\nint num_hist;\nint pos_epsp;\nint pos_temp;\nint pos_texture;\nint pos_damage;\nint erode_flag;\nint pos_erode_flag;\nstd::vector<int> curve;\nstd::vector<std::pair<int, std::string>> contour;","breadcrumbs":"Material configuration » Material properties » Class member variables","id":"25","title":"Class member variables"},"26":{"body":"bool gpu_enabled Set to true if GPU acceleration should be used, otherwise false. int num_hist The number of state variables used by each material model. The state variable array (p_history) is a container where one can store data for each integration point. These variables can change throughout the simulation. int pos_epsp Specifies where in the state variables array (p_history) the effective plastic strain variable is located. This is also used for damage properties . int pos_temp Thermal definition from for example *INITIAL_TEMPERATURE can be obtained through the pos_temp value. The value set will specify where in the state variables array (p_history) to set the initial temperature. This is also used for damage properties . int pos_texture When implementing material models using fiber direction (for example fiber composites) with *INITIAL_MATERIAL_DIRECTION_WRAP, a texture location must be set. The location tells IMPETUS Solver where in the state variables array (p_history) to set the initial fiber direction. It requires 9 slots (3 vectors) in the state variables array (from the specified index). Make sure to allocate enough space when setting num_hist. int pos_damage The location in the state variable array (p_history) where damage is stored. int erode_flg Specifies how the material model should handle damage evolution. 0: no element erosion / node splitting 1: element erosion 2: node splitting int erode_flg_pos Specifies the position of the erosion flag defined in material parameter list (p_cmat / cmat). If erode_flg_pos is set, the value in this position in cmat will be copied to cmat[80]. std::vector<int> curve Specifies where in the material parameter list (p_cmat / cmat) the curve / function ID's are located. Up to 50 curves can be specified per material models. Use curve.emplace_back(id) to add new entries. std::vector<std::pair<int, std::string>> contour Set a specific state variable for output, which can then be visualised as a contour plot in the GUI. Use contour.emplace_back(std::make_pair(id, \"Contour plot name\")); to add new entries.","breadcrumbs":"Material configuration » Material properties » Description","id":"26","title":"Description"},"27":{"body":"Note: This is optional. NO_REDUCTION is applied by default. Setting the stiffness arrays and these options will allow for IMPETUS Solver to control the critical time step calculations. If set, reduction operations (per element) will be performed for the specific data array(s). Options for each stiffness variable: NO_REDUCTION: No changes are made to the original values MAX_REDUCTION: The maximum value reduction is applied for each element MIN_REDUCTION: The minimum value reduction is applied for each element These reduction operations affect the following data arrays defined in UserMatDevice struct: stiff_shear affects device.dp_shear stiff_bulk affects device.dp_bulk stiff_xi affects device.dp_xi stiff_bfac affects device.dp_bfac","breadcrumbs":"Material configuration » Stiffness properties » Stiffness properties","id":"27","title":"Stiffness properties"},"28":{"body":"int stiff_shear int stiff_bulk int stiff_xi int stiff_bfac","breadcrumbs":"Material configuration » Stiffness properties » Class member variables","id":"28","title":"Class member variables"},"29":{"body":"bool stiff_shear Setting this property will apply reduction operations on the data.dp_shear array. Options: NO_REDUCTION: No changes are made to the original values MAX_REDUCTION: The maximum value reduction is applied for each element MIN_REDUCTION: The minimum value reduction is applied for each element int stiff_bulk Setting this property will apply reduction operations on the data.dp_shear array.bulk` array. Options: NO_REDUCTION: No changes are made to the original values MAX_REDUCTION: The maximum value reduction is applied for each element MIN_REDUCTION: The minimum value reduction is applied for each element int stiff_xi Setting this property will apply reduction operations on the data.dp_shear array.xi` array. Options: NO_REDUCTION: No changes are made to the original values MAX_REDUCTION: The maximum value reduction is applied for each element MIN_REDUCTION: The minimum value reduction is applied for each element int stiff_bfac Setting this property will apply reduction operations on the data.dp_shear array.bfac` array. Options: NO_REDUCTION: No changes are made to the original values MAX_REDUCTION: The maximum value reduction is applied for each element MIN_REDUCTION: The minimum value reduction is applied for each element","breadcrumbs":"Material configuration » Stiffness properties » Description","id":"29","title":"Description"},"3":{"body":"Windows Visual Studio 2022 (with Visual C++) NVIDIA CUDA Toolkit (CUDA 12.x) Linux GNU Make (make) GNU Compiler Collection (GCC) (g++) NVIDIA CUDA Toolkit (CUDA 12.x)","breadcrumbs":"Installation » Prerequisites","id":"3","title":"Prerequisites"},"30":{"body":"User material models can be combined with the *PROP_DAMAGE_[XXXX] commands, enabling the use of the build-in damage failure criterion models. This feature is ideal if one want to use well known and defined damage models. When a damage ID is specified, our software automatically uses the built-in implementation. The only requirements are that the positions of certain properties are defined. Some the variables, such as pos_epsp and pos_temp are overlapping with \"Material properties\". They are used for multiple purposes.","breadcrumbs":"Material configuration » Damage properties » Damage properties","id":"30","title":"Damage properties"},"31":{"body":"int pos_epsp int pos_depsp int pos_rate int pos_temp int pos_evol int pos_damage1 int pos_damage2","breadcrumbs":"Material configuration » Damage properties » Class member variables","id":"31","title":"Class member variables"},"32":{"body":"int pos_epsp Location of epsp in the state variables array. int pos_depsp Location of depsp in the state variables array. int pos_rate Location of rate in the state variables array. int pos_temp Location of temp in the state variables array. int pos_evol Location of evol in the state variables array. int pos_damage1 Location of damage1 in the state variables array. int pos_damage2 Location of damage2 in the state variables array.","breadcrumbs":"Material configuration » Damage properties » Description","id":"32","title":"Description"},"33":{"body":"","breadcrumbs":"Material configuration » Example » Example","id":"33","title":"Example"},"34":{"body":"MatMetal::MatMetal()\n{ // Enable GPU implementation of this material model gpu_enabled = true; // Material configuration num_hist = 6; // Number of state variables per integration point pos_epsp = 0; // For prop damage, sensor output pos_temp = 4; // For prop damage, prop thermal pos_texture = -1; // For texture, not used by this material model pos_damage = 1; // For damage, position in the state variable array erode_flag = 2; // Erosion flag (0=no erosion, 1=element erosion, 2=node splitting) pos_erode_flag = -1; // Not used, since this material model does not use element erosion pos_depsp = 5; // For prop damage pos_rate = -1; // For prop damage pos_evol = -1; // For prop damage pos_damage1 = 1; // For prop damage pos_damage2 = 2; // For prop damage // Curve definitions curve.emplace_back(6); // A curve ID is present at position 6 in the material parameter array (cmat) // Add the location in the state variable array and the output name for contour plot contour.emplace_back(std::make_pair(0, \"Effective plastic strain\")); contour.emplace_back(std::make_pair(1, \"Damage\")); contour.emplace_back(std::make_pair(4, \"Temperature\")); // Stiffness reduction (for GPU only) stiff_shear = NO_REDUCTION; stiff_bulk = NO_REDUCTION; stiff_xi = NO_REDUCTION; stiff_bfac = NO_REDUCTION;\n}","breadcrumbs":"Material configuration » Example » mat_metal.cpp","id":"34","title":"mat_metal.cpp"},"35":{"body":"This function is called during the initialization phase of the simulation. You can use it to set up any necessary data structures or perform other initialization tasks, such as the inital state of the material and, if required, calculate material parameters. This intialization function is called for both CPU and GPU implementations. Future implementations will enable the runInitGPU function when utilizing GPU acceleration.","breadcrumbs":"Material initialization » Material initialization","id":"35","title":"Material initialization"},"36":{"body":"void runInit(UserMatInitCPU data) const data Type: UserMatInitCPU Description: User material host data structure. See UserMatInitCPU for more information on the data structure.","breadcrumbs":"Material initialization » runInit()","id":"36","title":"runInit()"},"37":{"body":"void MatMetal::runInit(UserMatInitCPU data) const\n{ double young = data.p_cmat[1]; double pr = data.p_cmat[2]; double bulk = young / (3.0 * (1.0 - 2.0 * pr)); double G = young / (2.0 * (1.0 + pr)); // Set material properties data.p_cmat[43] = bulk; // Stress-strain curve int idlc = static_cast<int>(round(data.p_cmat[6])); // Yield stress double sigy0 = data.p_history[3]; // Set initial yield stress (if not already defined) if (sigy0 == 0.0) { // load material properties from database sigy0 = mat::load_curve(data.p_curve_data, data.p_curve_val, idlc, 0.0); data.p_history[3] = sigy0; } // Stiffness matrix data.p_stiffness[0] = G; data.p_stiffness[1] = bulk;\n}","breadcrumbs":"Material initialization » Example","id":"37","title":"Example"},"38":{"body":"Material response is the central mechanism for defining a material's complex behavior under varying conditions. Key aspects include the constitutive response, which governs how the material reacts to stress and strain and the failure criteria. These components can be tailored to accurately capture the unique properties of your needs. This framework offers two interfaces, one for CPU (C++) and another for GPU (CUDA).","breadcrumbs":"Material response » Material response","id":"38","title":"Material response"},"39":{"body":"This function is called for each integration point during each time step of the simulation on the CPU. It defines the behavior of the material, such as its constitutive response, failure criteria, and post-failure behavior.","breadcrumbs":"Material response » CPU implementation » CPU implementation","id":"39","title":"CPU implementation"},"4":{"body":"This framework contains the following folders and files: user-material-models/\n├── docs/\n├── example-models/\n├── output/\n└── user-material/ ├── gpu_error.cpp ├── gpu_error.h ├── interface.cpp ├── interface.h ├── kernel_mat_XXXX.cu ├── kernel_mat_XXXX.h ├── mat_user_defines.h ├── mat_user_functions.h ├── mat_user_structs_cpu.h ├── mat_user_structs_gpu.h ├── mat_user.h ├── mat_XXXX.cpp ├── mat_XXXX.h ├── user-material.vcxproj.filters └── user-material.vcxproj\n├── user-material.sln\n├── CMakeLists.txt\n└── Makefile The docs directory is where this documentation is located. The example-models directory contains example models that can be used to test the provided user material models. The output directory serves as the destination for the compiled DLL / shared object file if compilation is successful. The user-material directory contains C++ and CUDA code. The user-material.sln file is a Visual Studio 2022 solution file. It contains the compilation and execution configurations for the framework. The CMakeLists.txt provides a set of rules for building the user material project using Cmake The Makefile provides a set of rules for building the user material project under Linux. It contains the compilation and execution configurations for the framework.","breadcrumbs":"Structure » Structure","id":"4","title":"Structure"},"40":{"body":"void runMat(UserMatCPU data) const data Type: UserMatCPU Description: User material data structure. See UserMatCPU for more information on the data structure.","breadcrumbs":"Material response » CPU implementation » runMat()","id":"40","title":"runMat()"},"41":{"body":"void MatRubber::runMat(UserMatCPU data) const\n{ // Load material parameters double C1 = data.p_cmat[6]; double C2 = data.p_cmat[7]; double bulk = data.p_cmat[43]; double fmat[9], c[6], eval[3]; // Load deformation gradient matrix for (int i = 0; i < 9; ++i) { fmat[i] = data.p_f_mat[i]; } // Volumetric strain and pressure double evol = data.p_strain[0] + data.p_strain[1] + data.p_strain[2]; double pressure = -bulk * evol; mat::cauchy_green_tensor(fmat, c); // Re-using fmat array as eigen vector array since fmat array is no longer needed double* evec = fmat; // Get principal stretches (squared) mat::calc_eigen_values(c, eval); mat::calc_eigen_vectors(c, eval, evec); double alpha = 2.0 * C1 * (eval[0] - eval[2]) - 2.0 * C2 * (1.0 / eval[0] - 1.0 / eval[2]); double beta = 2.0 * C1 * (eval[1] - eval[2]) - 2.0 * C2 * (1.0 / eval[1] - 1.0 / eval[2]); eval[0] = (2.0 * alpha - 1.0 * beta) / 3.0 - pressure; eval[1] = (-1.0 * alpha + 2.0 * beta) / 3.0 - pressure; eval[2] = (-1.0 * alpha - 1.0 * beta) / 3.0 - pressure; // Re-using c array as local stress array since c array is not longer needed double* stress = c; for (int i = 0; i < 6; ++i) { stress[i] = 0.0; } for (int i = 0; i < 3; ++i) { int vector_offset = i * 3; stress[0] += eval[i] * pow(evec[vector_offset + 0], 2); stress[1] += eval[i] * pow(evec[vector_offset + 1], 2); stress[2] += eval[i] * pow(evec[vector_offset + 2], 2); stress[3] += eval[i] * evec[vector_offset + 0] * evec[vector_offset + 1]; stress[4] += eval[i] * evec[vector_offset + 1] * evec[vector_offset + 2]; stress[5] += eval[i] * evec[vector_offset + 2] * evec[vector_offset + 0]; } // Save eigen values for contour plot output for (int i = 0; i < 3; ++i) { data.p_history[i] = eval[i]; } // Save new stress for (int i = 0; i < 6; ++i) { data.p_stress[i] = stress[i]; }\n}","breadcrumbs":"Material response » CPU implementation » Example","id":"41","title":"Example"},"42":{"body":"In order to maximize performance, consider adopting a data transfer approach that involves loading data from heap memory (data arrays from UserMatCPU) into local stack variables at beginning of a function. By doing so, you can take advantage of the much faster memory access speeds from the stack compared to accessing data stored on the heap. This strategy allows for efficient processing and minimizes overhead associated with frequent heap memory accesses.","breadcrumbs":"Material response » CPU implementation » Memory access » CPU memory access","id":"42","title":"CPU memory access"},"43":{"body":"In the UserMatCPU, arrays with the p_ prefix are data pointers to arrays used for calculation of material response. Since arrays are structured per integration point for CPU implementation, there is no need to calculate global offsets. For instance, p_strain[0] through p_strain[5] relate to the current integration point.","breadcrumbs":"Material response » CPU implementation » Data access pattern » Data access pattern","id":"43","title":"Data access pattern"},"44":{"body":"This function is called for each integration point during each time step of the simulation on the CPU. It defines the behavior of the material, such as its constitutive response, failure criteria, and post-failure behavior. CUDA kernels (GPU code) cannot be implemented as a member functions in classes. The solution here is to implement them in separate files but invoked from the class function. To protecct against naming conflicts, we define the same namespace for both the class and the kernel that belong to each other.","breadcrumbs":"Material response » GPU implementation » GPU implementation","id":"44","title":"GPU implementation"},"45":{"body":"void runMatGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const host Type: UserMatHost Description: User material host data structure. See UserMatHost for more information on the data structure. device Type: UserMatDevice Description: User material device data structure. See UserMatDevice for more information on the data structure. stream Type: cudaStream_t Description: CUDA stream used by the material to perform its calculations.","breadcrumbs":"Material response » GPU implementation » runMatGPU()","id":"45","title":"runMatGPU()"},"46":{"body":"The following example calls the function mat_user(), which itself is part of the same namespace . We do not have to explicitly call the namespace, since both the class already belongs to the namespace. In our provided sample, the CUDA implementation is in a file called kernel_mat_rubber.cu. void MatRubber::runMatGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const\n{ mat_user(host, device, stream);\n}","breadcrumbs":"Material response » GPU implementation » Example","id":"46","title":"Example"},"47":{"body":"","breadcrumbs":"Material response » GPU implementation » CUDA programming model » CUDA programming model","id":"47","title":"CUDA programming model"},"48":{"body":"Functions marked with __global__ are kernels. A kernel is a special type of function that runs on the GPU and is executed in parallel by many threads. Kernels are the core mechanism by which you offload computation from the CPU (host) to the GPU (device).","breadcrumbs":"Material response » GPU implementation » CUDA programming model » Kernels","id":"48","title":"Kernels"},"49":{"body":"A __device__ function in CUDA is a type of function that is executed on the GPU and is callable only from other GPU functions, such as __global__ or other __device__ functions. These functions cannot be called directly from the host (CPU) code, unless they are also marked with __host__. This will make them callable from both the host and the device.","breadcrumbs":"Material response » GPU implementation » CUDA programming model » Functions","id":"49","title":"Functions"},"5":{"body":"","breadcrumbs":"Compilation » Compilation","id":"5","title":"Compilation"},"50":{"body":"__device__\nint sum(int x, int y) { return x + y;\n} __global__\nvoid kernel_add_vectors(int* a, int* b, int *c, int num_tasks) { int idx = threadIdx.x + blockIdx.x * blockDim.x; if (idx >= num_tasks) return; c[idx] = sum(a[idx], b[idx]);\n}","breadcrumbs":"Material response » GPU implementation » CUDA programming model » Example","id":"50","title":"Example"},"51":{"body":"For a more comprehensive understanding of CUDA, we recommend exploring the official NVIDIA CUDA documentation, which provides detailed guides, tutorials and reference materials. CUDA C++ Programming Guide","breadcrumbs":"Material response » GPU implementation » CUDA programming model » More information","id":"51","title":"More information"},"52":{"body":"The CUDA API is an extension of the C / C++ programming language and just like C / C++, CUDA uses header files. Each material model consists of two files, both defined within the same namespace: kernel_mat_XXXX.h (header) kernel_mat_XXXX.cu (source) Below is an example of our typical implementation, with logical code omitted for clarity and to focus on the interface. Further details will be provided in subsequent subsections.","breadcrumbs":"Material response » GPU implementation » CUDA kernel files » CUDA kernel files","id":"52","title":"CUDA kernel files"},"53":{"body":"The header file introduces a namespace and provides forward declarations of its host functions, enabling other files like to call them. namespace mat_kfc\n{ void mat_user(UserMatHost host, UserMatDevice device, cudaStream_t stream); }","breadcrumbs":"Material response » GPU implementation » CUDA kernel files » kernel_mat_XXXX.h","id":"53","title":"kernel_mat_XXXX.h"},"54":{"body":"The source file is wrapped in the same namespace as the header file. It contains the CUDA kernel function with the __global__ prefix, and a host function. The host function mat_user is used to launch the kernel function. Additionally, the file includes a __constant__ declaration of the the material properties struct. By utilizing the __constant__ memory space, we effectively cache frequently accessed data (such as material parameters). namespace mat_kfc\n{\n__constant__ double cmat[200]; __global__\nvoid kernel_sanders(UserMatDevice device)\n{ /* ⣿⣿⣿⣿⣿⣿⣿⡿⢟⣋⣭⣥⣭⣭⣍⡉⠉⠙⠛⠻⠿⣿⣿⣿⣿⣿⣿⣿⣿⣿ ⣿⣿⣿⣿⣿⡏⠁⠠⠶⠛⠻⠿⣿⣿⣿⣿⣷⡄⠄⠄⠄⠄⠉⠻⢿⣿⣿⣿⣿⣿ ⣿⣿⣿⣿⠟⠄⢀⡴⢊⣴⣶⣶⣾⣿⣿⣿⣿⢿⡄⠄⠄⠄⠄⠄⠄⠙⢿⣿⣿⣿ ⣿⣿⡿⠁⠄⠙⡟⠁⣾⣿⣿⣿⣿⣿⣿⣿⣿⣎⠃⠄⠄⠄⠄⠄⠄⠄⠈⢻⣿⣿ ⣿⡟⠄⠄⠄⠄⡇⠰⠟⠛⠛⠿⠿⠟⢋⢉⠍⢩⣠⡀⠄⠄⠄⠄⠄⠄⠄⠄⢹⣿ ⣿⠁⠄⠄⠄⠄⠰⠁⣑⣬⣤⡀⣾⣦⣶⣾⣖⣼⣿⠁⠄⠄⠄⠄⠄⠄⠄⠄⠄⢿ ⡏⠄⠄⠄⠄⠄⠄⠄⠨⣿⠟⠰⠻⠿⣣⡙⠿⣿⠋⠄⢀⡀⣀⠄⣀⣀⢀⣀⣀⢸ ⡇⠄⠄⠄⠄⠄⠄⠄⠄⣠⠄⠚⠛⠉⠭⣉⢁⣿⠄⢀⡿⢾⣅⢸⡗⠂⢿⣀⡀⢸ ⡇⠄⠄⠄⠄⠄⠄⠄⠄⠘⢧⣄⠄⣻⣿⣿⣾⠟⣀⠄⠄⠄⠄⠄⠄⠄⠄⠄⠄⢸ ⣿⠄⠄⠄⠄⠄⠄⠄⠄⢠⡀⠄⠄⣿⣿⠟⢁⣴⣿⢸⡄⠄⢦⣤⣤⣤⣤⣄⡀⣼ ⣿⣧⠄⠄⠄⠄⠄⠄⢠⡸⣿⠒⠄⠈⠛⠄⠁⢹⡟⣾⡇⠄⠈⢿⣿⣿⣿⣿⣿⣿ ⣿⣿⣧⣠⣴⣦⠄⠄⢸⣷⡹⣧⣖⡔⠄⠱⣮⣻⣷⣿⣿⠄⠄⠘⣿⣿⣿⣿⣿⣿ ⣿⣿⣿⣿⣿⡇⠄⠄⠸⠿⠿⠚⠛⠁⠂⠄⠉⠉⡅⢰⡆⢰⡄⠄⠘⣿⣿⣿⣿⣿ ⣿⣿⣿⣿⣿⣷⣤⡀⠄⠄⠄⠄⠄⠄⠄⠄⠄⠄⣿⠄⣷⠘⣧⣠⣾⣿⣿⣿⣿⣿ ⣿⣿⣿⣿⣿⣿⣿⣿⣷⣦⣤⣄⣀⣀⡀⠄⣀⣀⣹⣦⣽⣾⣿⣿⣿⣿⣿⣿⣿⣿ */\n} void kernelMaterial(UserMatHost host, UserMatDevice device, cudaStream_t stream)\n{ const unsigned int block_size = 128; const unsigned int num_blocks = calcNumBlocks(device.num_tasks, block_size); cudaMemcpyToSymbolAsync(cmat, host.p_material, sizeof(double) * 200, 0, cudaMemcpyHostToDevice, stream); kernel_sanders<<<num_blocks, block_size, 0, stream>>>(device);\n}\n} // namespace mat_kfc","breadcrumbs":"Material response » GPU implementation » CUDA kernel files » kernel_mat_XXXX.cu","id":"54","title":"kernel_mat_XXXX.cu"},"55":{"body":"","breadcrumbs":"Material response » GPU implementation » CUDA kernel launch » CUDA kernel launch","id":"55","title":"CUDA kernel launch"},"56":{"body":"__constant__ MatParams cmat; void kernelMaterial(UserMatHost host, UserMatDevice device, cudaStream_t stream)\n{ cudaMemcpyToSymbolAsync(cmat, host.p_material, sizeof(double) * 200, 0, cudaMemcpyHostToDevice, stream); const unsigned int block_size = 128; const unsigned int num_blocks = calcNumBlocks(data.num_tasks, block_size); kernel_material<<<num_blocks, block_size, 0, stream>>>(device); kernel_error_check(stream, __FILE__, __LINE__);\n} Copy material parameters array to constant memory space To use the material parameters in the kernel, we copy the data from host to device, more specifically the __constant__ memory space. This is done using the cudaMemcpyToSymbolAsync function (read more here ). Launching the kernel Number of blocks and threads per block Note: When launching a CUDA kernel, the total number of threads launched is determined by the product of the block size and the number of blocks. As a result, more threads are usually launched than necessary to process the data, since execution occurs at the block level rather than individual threads. const unsigned int block_size = 128;\nconst unsigned int num_blocks = calcNumBlocks(data.num_tasks, block_size); This code executes a GPU kernel to perform parallel computations on a large dataset. In CUDA, thread launching is achieved by executing multiple blocks, each with a specified size. The block size should be a multiple of 32, with a maximum of 1024 threads per block. Here, we use 128 threads per block and utilize the calcNumBlocks macro to calculate the number of blocks required based on the block size and the number of tasks to be processed. Kernel launch Note: CUDA kernels are launched asynchronously, meaning that they do not wait for the kernel to finish before continuing. To ensure that the kernel is finished before continuing with the application, synchronization is required. This can be done by calling the cudaStreamSynchronize function (read more here ). kernel_material<<<num_blocks, block_size, 0, stream>>>(device); kernel_material<<< num_blocks, block_size, 0, stream >>>(); is the kernel launch statement. The syntax <<<...>>> is called the execution configuration and it specifies how the kernel should be executed on the GPU. Any calls to a __global__ function must specify the execution configuration . To specify the execution configuration, you insert an expression in the format <<< gridDim, blockDim, sharedMem, stream >>> immediately after the function name and before the opening parenthesis of the argument, where: gridDim: The number of blocks in the grid (calculated by the calcNumBlocks macro); blockDim: The number of threads in each block (128 in this example); sharedMem: The number of bytes in shared memory that is dynamically allocated per block; stream: A CUDA stream object that manages the execution of the kernel. stream is an optional argument which defaults to 0. Error checking and synchronisation kernel_error_check(stream, __FILE__, __LINE__); Finally, we perform error checking using the kernel_error_check wrapper function. It checks for CUDA error codes, printing out an error message with file and line number if one occurs. This function also invoke stream synchronization (waits until the kernel has finished before continuing).","breadcrumbs":"Material response » GPU implementation » CUDA kernel launch » mat_user()","id":"56","title":"mat_user()"},"57":{"body":"CUDA threads are organized hierarchically into blocks, and these blocks are further organized into a grid. To efficiently map threads to data elements in parallel programming, CUDA provides a way to identify each thread uniquely using three built-in variables: threadIdx.x : This variable identifies the thread's index within a block. In a 1D block, threadIdx.x ranges from 0 to blockDim.x - 1. blockDim.x : This variable represents the total number of threads in each block along the x-axis. It is a constant value for all blocks within the grid. blockIdx.x : This variable identifies the block's index within the grid along the x-axis. In a 1D grid, blockIdx.x ranges from 0 to gridDim.x - 1, where gridDim.x is the total number of blocks in the grid along the x-axis.","breadcrumbs":"Material response » GPU implementation » Thread identifier » Thread identifier","id":"57","title":"Thread identifier"},"58":{"body":"Each thread in the grid can be uniquely identified by a combination of these three variables. The most common way to compute a unique index for a thread in a 1D execution is by combining these values as follows: int idx = threadIdx.x + blockIdx.x * blockDim.x;","breadcrumbs":"Material response » GPU implementation » Thread identifier » Compute a unique index","id":"58","title":"Compute a unique index"},"59":{"body":"The number of threads you launch might not perfectly match the number of tasks or data elements you want to process. For example, if you have a small number of tasks (num_tasks), but you launch a large number of threads, some of those threads would end up with no valid data to process. By checking if idx is greater than or equal to num_tasks, we can ensure that only the threads with valid work continue processing. This check effectively \"turns off\" threads that don't have anything to do, allowing the program to run safely and correctly. if (idx >= num_tasks) return;","breadcrumbs":"Material response » GPU implementation » Thread identifier » Preventing out-of-bounds access","id":"59","title":"Preventing out-of-bounds access"},"6":{"body":"This guide explains how to compile a \"Release\" version in Visual Studio, producing a DLL file named user-material.dll in the output folder. Open the Solution in Visual Studio Launch Visual Studio. Navigate to File > Open > Project/Solution.... Browse and select the solution file (impetus-user-material.sln), then click Open. Select the \"Release\" Configuration In the toolbar, find the \"Solution Configurations\" dropdown (usually located at the top of the window). Click the dropdown and select Release. This setting ensures that the build is optimised for performance. Build the Solution In the toolbar, click Build > Build Solution. Visual Studio will compile the solution using the \"Release\" configuration. Verify the Output After the build completes (if successful), navigate to the output directory output\\. Confirm that the user-material.dll file is present.","breadcrumbs":"Compilation » Windows","id":"6","title":"Windows"},"60":{"body":"","breadcrumbs":"Material response » GPU implementation » Memory access » Memory access","id":"60","title":"Memory access"},"61":{"body":"The preferred strategy is to load data from global memory at the beginning of a kernel and storing it locally, then writing it back at the end. This is mainly due to the significant difference in memory access speeds between different types of memory. Global memory latency Global memory is the main memory of the GPU, and it has a high latency, typically around 400 to 800 clock cycles. If every thread in a CUDA kernel were to access global memory frequently, it would lead to a significant slowdown due to this latency. Local and shared memory speed Local memory and shared memory are much faster than global memory. Shared memory, in particular, is on-chip and has a latency comparable to registers (typically around 1 clock cycle). By loading data from global memory into shared memory or registers at the beginning of a kernel, threads can then operate on this data using the much faster local or shared memory. By working with data locally (in registers or shared memory) during most of the kernel's execution, we minimize the need to repeatedly access global memory. This not only reduces latency but also reduces contention and traffic on the memory bus. Writing back the results to global memory at the end of the kernel also allows for a more structured approach.","breadcrumbs":"Material response » GPU implementation » Memory access » General memory access guidelines","id":"61","title":"General memory access guidelines"},"62":{"body":"For more information on memory access, see section 7.2. Variable Memory Space Specifiers : CUDA C++ Programming Guide","breadcrumbs":"Material response » GPU implementation » Memory access » Further reading","id":"62","title":"Further reading"},"63":{"body":"In the UserMatDevice, arrays with the dp_ prefix are device pointers, referring to memory allocated on the GPU. Device pointers are passed as arguments to the kernel.","breadcrumbs":"Material response » GPU implementation » Data access pattern » Data access pattern","id":"63","title":"Data access pattern"},"64":{"body":"Each thread is responsible for one element of the array, meaning that each thread operates on a unique index within the array. // Read\nint fail = dp_internal_fail[idx]; // Write\ndp_internal_fail[idx] = fail;","breadcrumbs":"Material response » GPU implementation » Data access pattern » Per-thread arrays","id":"64","title":"Per-thread arrays"},"65":{"body":"In contrast to individual threads operating on single data points, threads process fixed-size blocks of data. Specifically, each thread handles six data points that collectively represent a tensor's components. double stress[6]; // Read\nfor (int i = 0; i < 6; ++i) { stress[i] = dp_stress[idx * 6 + i];\n} // Write\nfor (int i = 0; i < 6; ++i) { dp_stress[idx * 6 + i] = stress[i];\n}","breadcrumbs":"Material response » GPU implementation » Data access pattern » Per-thread tensor arrays","id":"65","title":"Per-thread tensor arrays"},"66":{"body":"Similar to per-thread tensor arrays, but with a fixed-size block length of num_history. This value is obtained from the UserMatDevice properties struct. // Read\ndouble epsp = dp_history[idx * num_history + 0];\ndouble damage = dp_history[idx * num_history + 1]; // Write\ndp_history[idx * num_history + 0] = epsp;\ndp_history[idx * num_history + 1] = damage;","breadcrumbs":"Material response » GPU implementation » Data access pattern » Per-thread state variable arrays","id":"66","title":"Per-thread state variable arrays"},"67":{"body":"In this case, we employ a stride pattern. Stride access is a memory access pattern where threads access memory locations at uniform intervals, rather than sequential locations. Use the stride variable defined in the UserMatDevice properties struct. double fmat[9]; // Read\nfor (int i = 0; i < 9; ++i) { fmat[i] = dp_f_mat[stride * i + idx];\n} // Write\nfor (int i = 0; i < 9; ++i) { dp_f_mat[stride * i + idx] = fmat[i];\n}","breadcrumbs":"Material response » GPU implementation » Data access pattern » Per-thread 3x3 matrix arrays","id":"67","title":"Per-thread 3x3 matrix arrays"},"68":{"body":"// Read\nint eroded = dp_eroded[idx / num_ip]; // Write\ndp_eroded[idx / num_ip] = eroded; Important : Accessing subgroup-shared arrays may be subject to race conditions when reading or writing.","breadcrumbs":"Material response » GPU implementation » Data access pattern » Subgroup-shared array (element level)","id":"68","title":"Subgroup-shared array (element level)"},"69":{"body":"Curve arrays are used with the load_curve function to load a curve from a curve array into a variable. See the load_curve for more information. double sigy1 = mat::load_curve(dp_curve_data, dp_curve_val, cmat.idlc, epsp);","breadcrumbs":"Material response » GPU implementation » Data access pattern » Curve arrays","id":"69","title":"Curve arrays"},"7":{"body":"This guide explains how to compile your project on Linux using make. The output will be a shared library (DLL equivalent) named user-material.so located in the output directory. Navigate to the Project Directory Open a terminal window. Use the cd command to navigate to the directory containing your Makefile. cd /path/to/your/project Run the make Command Type make in the terminal and press Enter. This command will compile your project using the settings defined in the Makefile. make Verify the Output Once the build completes, open the output/ directory to confirm that the user-material.so file has been generated. ls output/ You should see user-material.so in the directory.","breadcrumbs":"Compilation » Linux","id":"7","title":"Linux"},"70":{"body":"This section explains how to integrate user material models with damage, thermal and equation-of-state properties.","breadcrumbs":"Material response » Property coupling » Property coupling","id":"70","title":"Property coupling"},"71":{"body":"User material models can be combined with the *PROP_DAMAGE_[XXXX] commands, enabling the use of the build-in damage failure criterion models. This feature is ideal if one want to use well known and defined damage models. When a damage ID is specified, our software automatically uses the built-in implementation. The only requirements are that the positions of certain properties are defined. Some the variables, such as pos_epsp and pos_temp are overlapping with \"Material properties\". They are used for multiple purposes.","breadcrumbs":"Material response » Property coupling » Use of damage property » Damage properties","id":"71","title":"Damage properties"},"72":{"body":"int pos_epsp int pos_depsp int pos_rate int pos_temp int pos_evol int pos_damage1 int pos_damage2","breadcrumbs":"Material response » Property coupling » Use of damage property » Class member variables","id":"72","title":"Class member variables"},"73":{"body":"int pos_epsp Location of epsp in the state variables array. int pos_depsp Location of depsp in the state variables array. int pos_rate Location of rate in the state variables array. int pos_temp Location of temp in the state variables array. int pos_evol Location of evol in the state variables array. int pos_damage1 Location of damage1 in the state variables array. int pos_damage2 Location of damage2 in the state variables array.","breadcrumbs":"Material response » Property coupling » Use of damage property » Description","id":"73","title":"Description"},"74":{"body":"When a thermal command ID is detected in the input data, it will store the relevant thermal properties within the material properties (host) array. The positions used for this are 70-74.","breadcrumbs":"Material response » Property coupling » Use of thermal property » Use of thermal property","id":"74","title":"Use of thermal property"},"75":{"body":"double hexp = data.p_cmat[70]; // Heat expansion coefficient\ndouble Cp = data.p_cmat[71]; // Thermal heat capacity\ndouble hcond = data.p_cmat[72]; // Thermal conductivity\ndouble k = data.p_cmat[73]; // Taylor-Quinney coefficient\ndouble Tref = data.p_cmat[74]; // Reference temperature for heat expansion","breadcrumbs":"Material response » Property coupling » Use of thermal property » C++","id":"75","title":"C++"},"76":{"body":"Since we're using __constant__ memory that resides in file scope, we can access the array directly from the kernel. double hexp = cmat[70]; // Heat expansion coefficient\ndouble Cp = cmat[71]; // Thermal heat capacity\ndouble hcond = cmat[72]; // Thermal conductivity\ndouble k = cmat[73]; // Taylor-Quinney coefficient\ndouble Tref = cmat[74]; // Reference temperature for heat expansion","breadcrumbs":"Material response » Property coupling » Use of thermal property » CUDA","id":"76","title":"CUDA"},"77":{"body":"The equation-of-state (EOS) ID is used to determine the EOS used for the material model. We currently only support *EOS_GRUNEISEN .","breadcrumbs":"Material response » Property coupling » Use of equation-of-state » Use of equation-of-state","id":"77","title":"Use of equation-of-state"},"78":{"body":"The EOS calculates the pressure at a given volume. This pressure is needed by the material model. You must handle this pressure manually in your material model, replacing the pressure that's normally part of the stress tensor. To check if EOS is enabled, use the eos parameter and the dp_eos_pressure array in the UserMatDevice struct. // Pressure based on volumetric strain or EOS if (eos == 0) { pressure = -cmat.bulk * (dp_strain[offset + 0] + dp_strain[offset + 1] + dp_strain[offset + 2]); } else { pressure = dp_eos_pressure[idx]; }","breadcrumbs":"Material response » Property coupling » Use of equation-of-state » GPU","id":"78","title":"GPU"},"79":{"body":"The calculated pressure from EOS is applied automatically to the stress tensor and requires no actions in the implementation.","breadcrumbs":"Material response » Property coupling » Use of equation-of-state » CPU","id":"79","title":"CPU"},"8":{"body":"The parameter input for user defined material models are defined using the *MAT_USER_[X] command in the input deck. See the *MAT_USER_X documentation for more information.","breadcrumbs":"Usage » Usage","id":"8","title":"Usage"},"80":{"body":"We provide four examples of material models, each with its own implementation.","breadcrumbs":"Examples » Examples","id":"80","title":"Examples"},"81":{"body":"The metal material model is designed to capture the elastic-plastic behavior of metallic materials. This model is well-suited for simulating materials such as steel, aluminium, and other common metallic alloys. Command structure *MAT_USER_1\nmid, dens, young, pr, did, tid, eos\nidlc, epsf Source code user-material/kernel_mat_metal.cu user-material/kernel_mat_metal.h user-material/mat_metal.cpp user-material/mat_metal.h","breadcrumbs":"Examples » Metal 🤘","id":"81","title":"Metal 🤘"},"82":{"body":"The concrete material model is a simplified version of the Holmquist-Johnson-Cook concrete model. The model includes a pressure dependent yield surface and inelastic compaction of the material. Command structure *MAT_USER_2\nmid, dens, G\nA, B, n, f_c, T, epsf_min, p_c, p_l\nepsv_c_l, D1, D2, K Source code user-material/kernel_mat_concrete.cu user-material/kernel_mat_concrete.h user-material/mat_concrete.cpp user-material/mat_concrete.h","breadcrumbs":"Examples » Concrete","id":"82","title":"Concrete"},"83":{"body":"The rubber material model is a hyperelastic implementation that describes the non-linear elastic behavior of rubber-like materials. This is essentially the classical Mooney-Rivlin model. Command structure *MAT_USER_3\nmid, dens, bulk\nC1, C2 Source code user-material/kernel_mat_rubber.cu user-material/kernel_mat_rubber.h user-material/mat_rubber.cpp user-material/mat_rubber.h","breadcrumbs":"Examples » Rubber","id":"83","title":"Rubber"},"84":{"body":"The orthotropic material model is specialised for materials that have different properties in three mutually perpendicular directions. It can be used for composite materials like wood and laminated composites, where directional dependency of mechanical properties is significant. Command structure *MAT_USER_4\nmid, dens\nE1, E2, G12, pr12, pr23\nc, cdec, Xt, Xc, Yt, Yc, beta, S\nerode, residual Source code user-material/kernel_mat_orthotropic.cu user-material/kernel_mat_orthotropic.h user-material/mat_orthotropic.cpp user-material/mat_orthotropic.h","breadcrumbs":"Examples » Orthotropic","id":"84","title":"Orthotropic"},"85":{"body":"These are the build-in API calls and data structures that are provided for the C++ interface.","breadcrumbs":"C++ API » C++ API","id":"85","title":"C++ API"},"86":{"body":"This function performs error CUDA kernels, printing out an error message with file and line number if error occurs. It function also waits until the kernel has finished before continuing with the program. void kernel_error_check(cudaStream_t stream, const char* file, int line) stream CUDA stream. file File name of source file. line Line number.","breadcrumbs":"C++ API » Error check » Error check","id":"86","title":"Error check"},"87":{"body":"These data structures are mainly used in the interface between IMPETUS Solver and the user material interface.","breadcrumbs":"C++ API » Data structures » Data structures","id":"87","title":"Data structures"},"88":{"body":"","breadcrumbs":"C++ API » Data structures » UserMatCPU » UserMatCPU","id":"88","title":"UserMatCPU"},"89":{"body":"int* p_internal_fail int* p_face_update int* p_curve_data\ndouble* p_curve_val\ndouble* p_strain\ndouble* p_dstrain\ndouble* p_stress\ndouble* p_f_mat\ndouble* p_u_mat\ndouble* p_history\ndouble* p_cmat\ndouble* p_stiffness double elem_volume0 double elem_volume double ip_volume0 double ip_volume int elem_id int ip_id int type double dt1 double tt int part_id int* p_face_ids\ndouble* p_face_area\ndouble* p_face_normal","breadcrumbs":"C++ API » Data structures » UserMatCPU » Structure","id":"89","title":"Structure"},"9":{"body":"In IMPETUS Solver GUI, navigate to Solve and then in the Ribbon menu click on Start simulation button. Browse for your input file. Check the \"Use defined material model\" check box. Browse for your DLL / shared object file. Click Start button to start the simulation.","breadcrumbs":"Usage » Start simulation with your DLL / shared object in the GUI","id":"9","title":"Start simulation with your DLL / shared object in the GUI"},"90":{"body":"int* p_internal_fail Integration point failure flag. int* p_face_update Force update of faces (used with erosion). int* p_curve_data Curve data, used together with load_curve . double* p_curve_val Curve data, used together with load_curve . double* p_strain Strain tensor. double* p_dstrain Strain increment tensor. double* p_stress Stress tensor. double* p_f_mat Deformation gradient matrix. double* p_u_mat Right stretch tensor. double* p_history History state variable array. double* p_cmat Material parameters array. double* p_stiffness Used for time step calculation. 0 = shear 1 = bulk 2 = xi 3 = bfac double elem_volume0 Inital volume of the element. double elem_volume Current volume of the element. double ip_volume0 Initial volume of the integration point. double ip_volume Current volume of the integration point. int elem_id Element ID. int ip_id Integration point ID. int type Element type. double dt1 Current time step size. double tt Current time. int type Part ID. int* p_face_ids Array of (maximum 3) face IDs tied to the current integration point. Non-zero value for each external face. double* p_face_area Area of the corresponding external face from p_face_ids. Use the index of p_face_ids where the value is not 0. double* p_face_normal Normal vector of the corresponding external face from p_face_ids. Use the index of p_face_ids where the value is not 0.","breadcrumbs":"C++ API » Data structures » UserMatCPU » Variables","id":"90","title":"Variables"},"91":{"body":"","breadcrumbs":"C++ API » Data structures » UserMatInitCPU » UserMatInitCPU","id":"91","title":"UserMatInitCPU"},"92":{"body":"int* p_curve_data\ndouble* p_curve_val\ndouble* p_strain\ndouble* p_stress\ndouble* p_coord\ndouble* p_history\ndouble* p_cmat\ndouble* p_stiffness int elem_id int ip_id int type int part_id int* p_face_ids\ndouble* p_face_area\ndouble* p_face_normal","breadcrumbs":"C++ API » Data structures » UserMatInitCPU » Structure","id":"92","title":"Structure"},"93":{"body":"int* p_curve_data Curve data, used together with load_curve . double* p_curve_val Curve data, used together with load_curve . double* p_strain Strain tensor. double* p_stress Stress tensor. double* p_coord Node coordinate. double* p_history History state variable array. double* p_cmat Material parameters array. double* p_stiffness Used for time step calculation. 0 = shear 1 = bulk 2 = xi 3 = bfac int elem_id Element ID. int ip_id Integration point ID. int type Element type. int part_id Part ID. int* p_face_ids Array of (maximum 3) face IDs tied to the current integration point. Non-zero value for each external face. double* p_face_area Area of the corresponding external face from p_face_ids. Use the index of p_face_ids where the value is not 0. double* p_face_normal Normal vector of the corresponding external face from p_face_ids. Use the index of p_face_ids where the value is not 0.","breadcrumbs":"C++ API » Data structures » UserMatInitCPU » Variables","id":"93","title":"Variables"},"94":{"body":"","breadcrumbs":"C++ API » Data structures » UserMatDevice » UserMatDevice","id":"94","title":"UserMatDevice"},"95":{"body":"int* dp_internal_fail int* dp_eroded int* dp_curve_data\ndouble* dp_curve_val\ndouble* dp_strain\ndouble* dp_dstrain\ndouble* dp_stress\ndouble* dp_f_mat\ndouble* dp_u_mat\ndouble* dp_init_volume\ndouble* dp_volume\ndouble* dp_history\ndouble* dp_eos_pressure\ndouble* dp_cmat\ndouble* dp_shear\ndouble* dp_bulk\ndouble* dp_xi\ndouble* dp_bfac int eos int num_history size_t num_ip size_t num_tasks size_t stride double dt0 double dt double tt","breadcrumbs":"C++ API » Data structures » UserMatDevice » Structure","id":"95","title":"Structure"},"96":{"body":"int* dp_internal_fail Integration point failure flag. Access pattern: Per-thread arrays int* dp_eroded Element eroded flag. Access pattern: Subgroup-shared array (element level) int* dp_curve_data Curve data. Access pattern: Curve arrays double* dp_curve_val Curve data. Access pattern: Curve arrays double* dp_strain Strain tensor. Access pattern: Per-thread tensor arrays double* dp_dstrain Strain increment tensor. Access pattern: Per-thread tensor arrays double* dp_stress Stress tensor. Access pattern: Per-thread tensor arrays double* dp_f_mat Deformation gradient matrix. This array is in stride format. Access pattern: Per-thread 3x3 matrix arrays double* p_u_mat Right stretch tensor. Access pattern: Per-thread tensor arrays double* dp_init_volume Initial volume of integration point. Access pattern: Per-thread arrays double* dp_volume Current volume of integration point. Access pattern: Per-thread arrays double* dp_history State variable array. Access pattern: Per-thread arrays double* dp_eos_pressure If Grüneisen equation of state is active, use is the pressure. Access pattern: Per-thread arrays double* dp_cmat Not used, currently a nullptr Note: Reserved for future implementation. double* dp_shear Shear array used for critical time step calculation. Access pattern: Per-thread arrays double* dp_bulk Bulk array used for critical time step calculation. Access pattern: Per-thread arrays double* dp_xi Xi array used for critical time step calculation. Access pattern: Per-thread arrays double* dp_bfac Bfac array used for critical time step calculation. Access pattern: Per-thread arrays int eos Flag to indicate whether Grüneisen equation-of-state is active or not. Use this flag to determine whether to use pressure from dp_eos_pressure or not. int num_history Number of state variables for the current material model. size_t num_ip Number of integration points of the current element. size_t num_tasks Number of threads to be launched for the current material model. size_t stride Stride used for arrays in stride format. double dt0 Previous time step. double dt1 Current time step. double tt Current time.","breadcrumbs":"C++ API » Data structures » UserMatDevice » Variables","id":"96","title":"Variables"},"97":{"body":"","breadcrumbs":"C++ API » Data structures » UserMatHost » UserMatHost","id":"97","title":"UserMatHost"},"98":{"body":"double* p_material","breadcrumbs":"C++ API » Data structures » UserMatHost » Structure","id":"98","title":"Structure"},"99":{"body":"double* p_material Material parameters (host array).","breadcrumbs":"C++ API » Data structures » UserMatHost » Variables","id":"99","title":"Variables"}},"length":127,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":1.0}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":12,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":2.8284271247461903},"54":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}},"1":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"0":{"2":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"2":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"8":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":2.0}}},"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"=":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"d":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"df":11,"docs":{"104":{"tf":1.0},"123":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"2":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}},"2":{"2":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}},"4":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":8,"docs":{"104":{"tf":1.0},"125":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"37":{"tf":1.0},"41":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":2,"docs":{"22":{"tf":1.0},"56":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"df":5,"docs":{"104":{"tf":1.0},"26":{"tf":1.0},"41":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"x":{"3":{"df":5,"docs":{"102":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"67":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"0":{"0":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":1.0}}},"5":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"34":{"tf":1.0}}},"6":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"65":{"tf":2.0}}},"7":{".":{"2":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"74":{"tf":1.0}}},"4":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"0":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"26":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"_":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"_":{"df":3,"docs":{"54":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"_":{"df":14,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"_":{"df":5,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"_":{"df":13,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"1":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"2":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"3":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"26":{"tf":1.0},"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":13,"docs":{"22":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"76":{"tf":1.0},"96":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"56":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"14":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"79":{"tf":1.0}}}},"v":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}},"d":{"d":{"df":3,"docs":{"10":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":5,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0}}},"y":{"df":1,"docs":{"81":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"41":{"tf":2.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"37":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"81":{"tf":1.0}}}}}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"52":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":3,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":3.4641016151377544},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":1,"docs":{"27":{"tf":1.0}}},".":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":25,"docs":{"119":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"41":{"tf":2.449489742783178},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"56":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"73":{"tf":2.6457513110645907},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":4.898979485566356},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"b":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"78":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":1,"docs":{"16":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"100":{"tf":1.0},"56":{"tf":2.0},"86":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}},"{":{"b":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}},"w":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"a":{"df":2,"docs":{"41":{"tf":2.0},"84":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"19":{"tf":1.0},"61":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"f":{"a":{"c":{"df":3,"docs":{"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"56":{"tf":2.6457513110645907}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"56":{"tf":3.7416573867739413},"57":{"tf":2.6457513110645907},"65":{"tf":1.0},"66":{"tf":1.0}},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"19":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":1,"docs":{"61":{"tf":1.0}},"g":{"df":1,"docs":{"19":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"2":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"7":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"11":{"tf":1.0},"30":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":6,"docs":{"37":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"83":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"c":{"1":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"2":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"[":{"6":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"s":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":15,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":2.0}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":10,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"85":{"tf":1.0}}}},"p":{"a":{"c":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"81":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.4142135623730951}}},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":18,"docs":{"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"62":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"86":{"tf":1.0}},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"56":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"78":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"12":{"tf":2.449489742783178},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"72":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"6":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"t":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"[":{"2":{"0":{"0":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.0}}},"2":{"df":1,"docs":{"76":{"tf":1.0}}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"4":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"34":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"19":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"30":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"58":{"tf":1.0},"81":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}},"x":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"14":{"tf":1.0},"38":{"tf":1.0},"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":4,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.7320508075688772},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"42":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"52":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"df":10,"docs":{"14":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.0},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"26":{"tf":1.0},"4":{"tf":2.23606797749979},"54":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"(":{"0":{"df":1,"docs":{"34":{"tf":1.0}}},"1":{"df":1,"docs":{"34":{"tf":1.0}}},"4":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.0},"41":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"82":{"tf":1.0}}},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"1":{"tf":2.0},"26":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}},"u":{"df":11,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":4,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"i":{"c":{"df":3,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"96":{"tf":2.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"103":{"tf":1.4142135623730951}}}}}},"u":{"d":{"a":{"df":21,"docs":{"100":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":2.0},"38":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"124":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"77":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.0},"96":{"tf":2.6457513110645907}}}}}},"v":{"df":10,"docs":{"118":{"tf":1.0},"119":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"69":{"tf":2.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"6":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"118":{"tf":1.0},"119":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":2,"docs":{"118":{"tf":1.0},"119":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"1":{"df":1,"docs":{"82":{"tf":1.0}}},"2":{"df":1,"docs":{"82":{"tf":1.0}}},"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"1":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":2.0},"34":{"tf":3.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0}},"e":{"1":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}}},"2":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{".":{"d":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"1":{"df":1,"docs":{"37":{"tf":1.0}}},"2":{"df":1,"docs":{"37":{"tf":1.0}}},"4":{"3":{"df":2,"docs":{"37":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"41":{"tf":1.0}}},"7":{"0":{"df":1,"docs":{"75":{"tf":1.0}}},"1":{"df":1,"docs":{"75":{"tf":1.0}}},"2":{"df":1,"docs":{"75":{"tf":1.0}}},"3":{"df":1,"docs":{"75":{"tf":1.0}}},"4":{"df":1,"docs":{"75":{"tf":1.0}}},"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"[":{"3":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"1":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"1":{"df":1,"docs":{"41":{"tf":1.0}}},"2":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":26,"docs":{"119":{"tf":1.0},"14":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":1.4142135623730951},"45":{"tf":2.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":2.0},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"74":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"100":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"112":{"tf":1.0},"114":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"n":{"df":4,"docs":{"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":4,"docs":{"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":4,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"101":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.7320508075688772},"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"i":{"c":{"df":11,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951}},"e":{".":{"d":{"df":0,"docs":{},"p":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"14":{"tf":1.0},"49":{"tf":1.0},"76":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"o":{"c":{"df":1,"docs":{"4":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":1,"docs":{"42":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.4142135623730951}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":20,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"37":{"tf":2.23606797749979},"41":{"tf":3.1622776601683795},"54":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":2.23606797749979},"76":{"tf":2.23606797749979},"89":{"tf":4.123105625617661},"90":{"tf":4.123105625617661},"92":{"tf":3.0},"93":{"tf":3.0},"95":{"tf":4.242640687119285},"96":{"tf":4.242640687119285},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":3,"docs":{"69":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"63":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"78":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}},"e":{"d":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"y":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}}}}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"u":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"x":{"df":0,"docs":{},"i":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"t":{"0":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"1":{"df":3,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}},"df":1,"docs":{"95":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}},"1":{"df":1,"docs":{"84":{"tf":1.0}}},"2":{"df":1,"docs":{"84":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"h":{"df":21,"docs":{"100":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"39":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"110":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"14":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.4142135623730951}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"101":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}},"e":{"0":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"34":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"59":{"tf":1.0},"61":{"tf":1.4142135623730951}},"{":{"b":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"23":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"o":{"df":6,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"79":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":1,"docs":{"81":{"tf":1.0}}},"p":{"df":6,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"73":{"tf":1.0}}},"v":{"_":{"c":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}},"t":{"df":3,"docs":{"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.7320508075688772},"34":{"tf":2.0},"90":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":2.0},"86":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"41":{"tf":2.23606797749979}}},"3":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":2.6457513110645907}}}},"df":5,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"[":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":2.449489742783178}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"113":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.4142135623730951},"73":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":15,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":2.8284271247461903},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":2.8284271247461903},"58":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}}}}}}},"f":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"119":{"tf":1.0}}}},"_":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"90":{"tf":2.23606797749979},"93":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"14":{"tf":1.4142135623730951},"30":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"71":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"4":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"d":{"df":2,"docs":{"10":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.7320508075688772},"86":{"tf":1.0}}}},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}},"x":{"df":2,"docs":{"65":{"tf":1.0},"66":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"124":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":2.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"[":{"9":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":1,"docs":{"41":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"27":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0}}}}}},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":29,"docs":{"100":{"tf":2.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"121":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":3.0},"26":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.449489742783178},"53":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":2.449489742783178},"69":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"35":{"tf":1.0},"96":{"tf":1.0}}}}}}},"g":{"1":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"c":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"61":{"tf":1.0},"7":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"61":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"u":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":14,"docs":{"11":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"78":{"tf":1.0}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"101":{"tf":1.4142135623730951}}}}},"i":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.0}}},"df":0,"docs":{}},"ü":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":3,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"26":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"t":{"df":2,"docs":{"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":3,"docs":{"12":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"p":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":12,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"74":{"tf":1.0},"99":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"i":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":10,"docs":{"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"18":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"90":{"tf":2.0},"93":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":2.0},"58":{"tf":1.0}}}}}}}},"l":{"c":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"df":0,"docs":{}},"x":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"6":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"100":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"19":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.0}}}}},"df":0,"docs":{}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.0},"54":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"126":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":6,"docs":{"26":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"i":{"c":{"df":2,"docs":{"124":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":9,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"1":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"90":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":8,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":2.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"126":{"tf":2.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"]":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"c":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":29,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":2.6457513110645907},"26":{"tf":2.6457513110645907},"28":{"tf":2.0},"29":{"tf":1.7320508075688772},"31":{"tf":2.6457513110645907},"32":{"tf":2.6457513110645907},"37":{"tf":1.0},"41":{"tf":2.449489742783178},"50":{"tf":2.449489742783178},"54":{"tf":1.4142135623730951},"56":{"tf":2.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":2.6457513110645907},"73":{"tf":2.6457513110645907},"86":{"tf":1.0},"89":{"tf":2.8284271247461903},"90":{"tf":2.8284271247461903},"92":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"95":{"tf":2.23606797749979},"96":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":9,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":1,"docs":{"67":{"tf":1.0}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"53":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"3":{"df":0,"docs":{},"x":{"3":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"p":{"_":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}},"e":{"0":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}},"k":{"df":3,"docs":{"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"61":{"tf":1.0}}},"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"u":{"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"u":{"df":3,"docs":{"4":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"4":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"<":{"<":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"<":{"<":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":11,"docs":{"14":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":2.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":3.4641016151377544},"61":{"tf":2.0},"63":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"y":{"df":2,"docs":{"101":{"tf":1.0},"38":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"52":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"56":{"tf":1.0},"59":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"61":{"tf":2.23606797749979}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.8284271247461903},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"56":{"tf":1.0},"68":{"tf":1.0},"96":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":3,"docs":{"10":{"tf":1.0},"56":{"tf":1.0},"86":{"tf":2.0}}},"k":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"x":{"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"o":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"69":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":6,"docs":{"118":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"61":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":2.23606797749979}}},"t":{"df":9,"docs":{"10":{"tf":1.0},"26":{"tf":2.23606797749979},"32":{"tf":2.6457513110645907},"34":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"49":{"tf":1.0},"7":{"tf":2.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}},"t":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":2,"docs":{"115":{"tf":1.0},"116":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"f":{"c":{"df":2,"docs":{"53":{"tf":1.0},"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},".":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}}},"_":{"1":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"81":{"tf":1.0}}},"2":{"df":1,"docs":{"82":{"tf":1.0}}},"3":{"df":1,"docs":{"83":{"tf":1.0}}},"4":{"df":1,"docs":{"84":{"tf":1.0}}},"[":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":2,"docs":{"100":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"1":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}},"2":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":5,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},".":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"v":{"c":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":51,"docs":{"0":{"tf":2.6457513110645907},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"100":{"tf":1.0},"101":{"tf":1.0},"11":{"tf":2.23606797749979},"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"16":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"26":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951},"34":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":2.449489742783178},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"87":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":11,"docs":{"102":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"37":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":2.23606797749979},"17":{"tf":1.0}}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"27":{"tf":1.0},"29":{"tf":2.0},"56":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"38":{"tf":1.0},"48":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"72":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"42":{"tf":2.0},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":4.47213595499958},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"81":{"tf":2.0}}}},"df":0,"docs":{}}},"i":{"d":{"df":4,"docs":{"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":26,"docs":{"0":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"26":{"tf":2.0},"30":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"47":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"56":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"19":{"tf":2.6457513110645907},"26":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":8,"docs":{"100":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":3.3166247903554},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":1,"docs":{"82":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":7,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"34":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"83":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":2.0}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"121":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"66":{"tf":2.23606797749979},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":3.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"86":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"11":{"tf":1.0}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"4":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"26":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":6,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"56":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}},"r":{"df":5,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"29":{"tf":2.0},"56":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.7320508075688772},"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"118":{"tf":1.0},"120":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"86":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.7320508075688772},"126":{"tf":2.0},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":1,"docs":{"11":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"12":{"tf":1.0},"14":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}}}}}}},"p":{"_":{"c":{"df":1,"docs":{"82":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"43":{"tf":1.0}},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":2.23606797749979},"92":{"tf":1.0},"93":{"tf":2.23606797749979}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"26":{"tf":2.23606797749979},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"l":{"df":1,"docs":{"82":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"98":{"tf":1.0},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"5":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"u":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"48":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":26,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":5,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"96":{"tf":4.123105625617661}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":2.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"96":{"tf":3.7416573867739413}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":9,"docs":{"100":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"86":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"124":{"tf":1.0},"126":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"41":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":1.4142135623730951},"90":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"s":{"_":{"d":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}},"e":{"1":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"2":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":9,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":9,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"[":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"r":{"1":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":1.7320508075688772},"81":{"tf":1.0}},"e":{"df":1,"docs":{"100":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"6":{"tf":1.0}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"41":{"tf":2.23606797749979},"78":{"tf":2.6457513110645907},"79":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"42":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"65":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"6":{"tf":1.0}},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":7,"docs":{"47":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"_":{"d":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"[":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":17,"docs":{"0":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.7320508075688772},"46":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"1":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}}},"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"d":{"df":7,"docs":{"56":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"27":{"tf":2.0},"29":{"tf":3.4641016151377544},"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"41":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"51":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"43":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":2.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"74":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"23":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"121":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}},"u":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":7,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":12,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}}}},"i":{"b":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"101":{"tf":1.0}}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":4,"docs":{"15":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"36":{"tf":1.0}},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"40":{"tf":1.0}},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"59":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"df":7,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}}},"t":{"df":12,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":2.8284271247461903},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}},"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":2.449489742783178},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":5,"docs":{"100":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"a":{"_":{"df":0,"docs":{},"{":{"1":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"2":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"3":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"0":{"df":5,"docs":{"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"37":{"tf":2.0}}},"1":{"df":3,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}},"x":{"df":1,"docs":{"65":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772}}}},"df":4,"docs":{"56":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0}}},"w":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":3.0},"11":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":2.449489742783178}}}},"v":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":7,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"26":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"0":{"tf":1.0},"121":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"26":{"tf":2.6457513110645907},"30":{"tf":1.0},"56":{"tf":2.0},"62":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"11":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"9":{"tf":2.0}}}},"t":{"df":0,"docs":{},"e":{"df":13,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":2.8284271247461903},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":2.6457513110645907},"77":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":2.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"i":{"c":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"6":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}},"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}},"p":{"df":9,"docs":{"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":2.449489742783178}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"df":3,"docs":{"27":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"42":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":14,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":2.0},"26":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{">":{">":{">":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.8284271247461903},"86":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"1":{"df":1,"docs":{"41":{"tf":1.0}}},"2":{"df":1,"docs":{"41":{"tf":1.0}}},"3":{"df":1,"docs":{"41":{"tf":1.0}}},"4":{"df":1,"docs":{"41":{"tf":1.0}}},"5":{"df":1,"docs":{"41":{"tf":1.0}}},"6":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}}}},"df":15,"docs":{"108":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":2.0},"125":{"tf":1.0},"126":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"67":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"27":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":19,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.0},"61":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.0}}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":10,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"m":{"(":{"a":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"s":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"f":{"a":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"21":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"t":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"a":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":5,"docs":{"100":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":11,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"121":{"tf":2.0},"123":{"tf":2.23606797749979},"125":{"tf":2.8284271247461903},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"65":{"tf":1.0}}},"df":21,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":2.8284271247461903}}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"34":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"df":11,"docs":{"48":{"tf":1.0},"56":{"tf":2.8284271247461903},"57":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":2.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"96":{"tf":3.872983346207417}},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"84":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}},"i":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.0},"96":{"tf":2.6457513110645907}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"p":{"df":1,"docs":{"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"34":{"tf":1.0}}}}},"t":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"38":{"tf":1.0},"52":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":11,"docs":{"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"52":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"64":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}}},"df":41,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":2.6457513110645907},"30":{"tf":2.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":2.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.449489742783178},"93":{"tf":2.23606797749979},"96":{"tf":3.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":22,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":3.1622776601683795},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":2.0},"83":{"tf":2.0},"84":{"tf":2.0},"87":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":4,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"88":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":13,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"27":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":12,"docs":{"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"29":{"tf":3.4641016151377544},"41":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":25,"docs":{"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":3.1622776601683795},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"42":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.6457513110645907},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":5,"docs":{"104":{"tf":1.7320508075688772},"26":{"tf":1.0},"41":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":2.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":21,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"78":{"tf":1.0},"90":{"tf":2.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"n":{"df":2,"docs":{"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"y":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"3":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.7320508075688772},"64":{"tf":1.0},"74":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"19":{"tf":2.0}}}}}}}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"100":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}}},"x":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":5,"docs":{"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}},"i":{"df":3,"docs":{"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"y":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":1,"docs":{"50":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.7320508075688772},"81":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":1.0}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":12,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":2.8284271247461903},"54":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}},"1":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"0":{"2":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"2":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"8":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":2.0}}},"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"=":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"d":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"df":12,"docs":{"104":{"tf":1.0},"123":{"tf":2.0},"124":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"2":{".":{"0":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}},"2":{"2":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}},"4":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"104":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"37":{"tf":1.0},"41":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":2,"docs":{"22":{"tf":1.0},"56":{"tf":1.0}}},"3":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"df":5,"docs":{"104":{"tf":1.0},"26":{"tf":1.0},"41":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"x":{"3":{"df":6,"docs":{"102":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"67":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"0":{"0":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":1.0}}},"5":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"34":{"tf":1.0}}},"6":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"65":{"tf":2.0}}},"7":{".":{"2":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"74":{"tf":1.0}}},"4":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"0":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"26":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"_":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"_":{"df":3,"docs":{"54":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"_":{"df":14,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"_":{"df":5,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"_":{"df":13,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"1":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"2":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"3":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"26":{"tf":1.0},"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":17,"docs":{"22":{"tf":1.4142135623730951},"42":{"tf":2.449489742783178},"43":{"tf":1.7320508075688772},"54":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":2.449489742783178},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"76":{"tf":1.0},"96":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"56":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"14":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"79":{"tf":1.0}}}},"v":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}},"d":{"d":{"df":3,"docs":{"10":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":5,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0}}},"y":{"df":1,"docs":{"81":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"41":{"tf":2.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"37":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"81":{"tf":1.0}}}}}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":43,"docs":{"100":{"tf":2.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"52":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":3,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":3.4641016151377544},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":1,"docs":{"27":{"tf":1.0}}},".":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":25,"docs":{"119":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"41":{"tf":2.449489742783178},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"56":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":2.0},"73":{"tf":2.6457513110645907},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":4.898979485566356},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"b":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"78":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":1,"docs":{"16":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"100":{"tf":1.0},"56":{"tf":2.0},"86":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}},"{":{"b":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}},"w":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"a":{"df":2,"docs":{"41":{"tf":2.0},"84":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"19":{"tf":1.0},"61":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"f":{"a":{"c":{"df":3,"docs":{"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"56":{"tf":2.6457513110645907}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"56":{"tf":3.7416573867739413},"57":{"tf":2.6457513110645907},"65":{"tf":1.0},"66":{"tf":1.0}},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"19":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":1,"docs":{"61":{"tf":1.0}},"g":{"df":1,"docs":{"19":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"2":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"7":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"11":{"tf":1.0},"30":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":6,"docs":{"37":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"83":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"c":{"1":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"2":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"[":{"6":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"s":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":15,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":2.0}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":10,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"85":{"tf":1.0}}}},"p":{"a":{"c":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"81":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":2.0},"102":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":56,"docs":{"1":{"tf":1.0},"100":{"tf":2.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"62":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"86":{"tf":1.0}},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"56":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"78":{"tf":1.0},"86":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"12":{"tf":2.8284271247461903},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"72":{"tf":1.4142135623730951}},"i":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"6":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"t":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"[":{"2":{"0":{"0":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.0}}},"2":{"df":1,"docs":{"76":{"tf":1.0}}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"4":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"34":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"19":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"30":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"58":{"tf":1.0},"81":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}},"x":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"14":{"tf":1.0},"38":{"tf":1.0},"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":4,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}}},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":18,"docs":{"13":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"42":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"52":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"df":10,"docs":{"14":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.0},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"26":{"tf":1.0},"4":{"tf":2.23606797749979},"54":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"(":{"0":{"df":1,"docs":{"34":{"tf":1.0}}},"1":{"df":1,"docs":{"34":{"tf":1.0}}},"4":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.0},"41":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"82":{"tf":1.0}}},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"1":{"tf":2.0},"26":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"70":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}},"u":{"df":13,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":4,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"i":{"c":{"df":3,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"96":{"tf":2.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":2,"docs":{"103":{"tf":2.0},"104":{"tf":1.0}}}}}},"u":{"d":{"a":{"df":50,"docs":{"100":{"tf":2.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":2.0},"38":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":2.449489742783178},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"(":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"124":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"77":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.0},"96":{"tf":2.6457513110645907}}}}}},"v":{"df":11,"docs":{"118":{"tf":1.7320508075688772},"119":{"tf":2.0},"120":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"69":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"6":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"118":{"tf":1.0},"119":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":2,"docs":{"118":{"tf":1.0},"119":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"1":{"df":1,"docs":{"82":{"tf":1.0}}},"2":{"df":1,"docs":{"82":{"tf":1.0}}},"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":11,"docs":{"1":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":3.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"1":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}}},"2":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{".":{"d":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"1":{"df":1,"docs":{"37":{"tf":1.0}}},"2":{"df":1,"docs":{"37":{"tf":1.0}}},"4":{"3":{"df":2,"docs":{"37":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"41":{"tf":1.0}}},"7":{"0":{"df":1,"docs":{"75":{"tf":1.0}}},"1":{"df":1,"docs":{"75":{"tf":1.0}}},"2":{"df":1,"docs":{"75":{"tf":1.0}}},"3":{"df":1,"docs":{"75":{"tf":1.0}}},"4":{"df":1,"docs":{"75":{"tf":1.0}}},"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"[":{"3":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"1":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"1":{"df":1,"docs":{"41":{"tf":1.0}}},"2":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":40,"docs":{"119":{"tf":1.0},"14":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":2.0},"45":{"tf":2.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"100":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"112":{"tf":1.0},"114":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"11":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"n":{"df":4,"docs":{"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":4,"docs":{"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":4,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"101":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"26":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"i":{"c":{"df":11,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951}},"e":{".":{"d":{"df":0,"docs":{},"p":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"14":{"tf":1.0},"49":{"tf":1.0},"76":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"o":{"c":{"df":1,"docs":{"4":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":1,"docs":{"42":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.4142135623730951}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":20,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"37":{"tf":2.23606797749979},"41":{"tf":3.1622776601683795},"54":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":2.23606797749979},"76":{"tf":2.23606797749979},"89":{"tf":4.123105625617661},"90":{"tf":4.123105625617661},"92":{"tf":3.0},"93":{"tf":3.0},"95":{"tf":4.242640687119285},"96":{"tf":4.242640687119285},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":3,"docs":{"69":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"63":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"78":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}},"e":{"d":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"y":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}}}}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"u":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"x":{"df":0,"docs":{},"i":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"t":{"0":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}},"1":{"df":3,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}},"df":1,"docs":{"95":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}},"1":{"df":1,"docs":{"84":{"tf":1.0}}},"2":{"df":1,"docs":{"84":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"h":{"df":21,"docs":{"100":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"39":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":2.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"14":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.4142135623730951}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":4,"docs":{"111":{"tf":2.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"113":{"tf":2.0},"114":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"101":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}},"e":{"0":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"34":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"90":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"59":{"tf":1.0},"61":{"tf":1.4142135623730951}},"{":{"b":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"23":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"o":{"df":6,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"79":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":1,"docs":{"81":{"tf":1.0}}},"p":{"df":6,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"73":{"tf":1.0}}},"v":{"_":{"c":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}},"t":{"df":5,"docs":{"70":{"tf":1.0},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.7320508075688772},"34":{"tf":2.0},"90":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":2.0},"86":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"41":{"tf":2.23606797749979}}},"3":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":2.6457513110645907}}}},"df":5,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"[":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":2.449489742783178}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"113":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.4142135623730951},"73":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":2.8284271247461903},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":2.8284271247461903},"58":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}}}}}}},"f":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"119":{"tf":1.0}}}},"_":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"90":{"tf":2.23606797749979},"93":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"14":{"tf":1.4142135623730951},"30":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"71":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"4":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"54":{"tf":2.0},"56":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"d":{"df":2,"docs":{"10":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.7320508075688772},"86":{"tf":1.0}}}},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}},"x":{"df":2,"docs":{"65":{"tf":1.0},"66":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"124":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":2.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"[":{"9":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":1,"docs":{"41":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"27":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0}}}}}},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":30,"docs":{"100":{"tf":2.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"12":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":3.0},"26":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.6457513110645907},"53":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":2.449489742783178},"69":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"35":{"tf":1.0},"96":{"tf":1.0}}}}}}},"g":{"1":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"c":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"61":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"u":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":34,"docs":{"11":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":2.0},"102":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.0}}},"df":0,"docs":{}},"ü":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}},"df":3,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"26":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"t":{"df":2,"docs":{"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":3,"docs":{"12":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"p":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":12,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"74":{"tf":1.0},"99":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"i":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":10,"docs":{"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"18":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"90":{"tf":2.0},"93":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"57":{"tf":2.449489742783178},"58":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}}}}},"l":{"c":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"df":0,"docs":{}},"x":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"6":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":49,"docs":{"100":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"19":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.0}}}}},"df":0,"docs":{}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.0},"54":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"126":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"126":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":6,"docs":{"26":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"64":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"i":{"c":{"df":2,"docs":{"124":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":9,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"1":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"90":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":9,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"35":{"tf":2.23606797749979},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":2.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"126":{"tf":2.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":2.0},"3":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"]":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"c":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":29,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":2.6457513110645907},"26":{"tf":2.6457513110645907},"28":{"tf":2.0},"29":{"tf":1.7320508075688772},"31":{"tf":2.6457513110645907},"32":{"tf":2.6457513110645907},"37":{"tf":1.0},"41":{"tf":2.449489742783178},"50":{"tf":2.449489742783178},"54":{"tf":1.4142135623730951},"56":{"tf":2.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":2.6457513110645907},"73":{"tf":2.6457513110645907},"86":{"tf":1.0},"89":{"tf":2.8284271247461903},"90":{"tf":2.8284271247461903},"92":{"tf":2.449489742783178},"93":{"tf":2.449489742783178},"95":{"tf":2.23606797749979},"96":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":11,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":1,"docs":{"67":{"tf":1.0}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"53":{"tf":1.0}},"t":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"3":{"df":0,"docs":{},"x":{"3":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"115":{"tf":2.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"p":{"_":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}},"e":{"0":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}},"k":{"df":3,"docs":{"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"61":{"tf":1.0}}},"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"u":{"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"u":{"df":3,"docs":{"4":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"4":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"<":{"<":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"<":{"<":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":12,"docs":{"14":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"56":{"tf":3.605551275463989},"61":{"tf":2.0},"63":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"y":{"df":2,"docs":{"101":{"tf":1.0},"38":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"52":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"56":{"tf":1.0},"59":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"61":{"tf":2.23606797749979}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":3.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"56":{"tf":1.0},"68":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":3,"docs":{"10":{"tf":1.0},"56":{"tf":1.0},"86":{"tf":2.0}}},"k":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"x":{"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"o":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"69":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":8,"docs":{"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"61":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":2.23606797749979}}},"t":{"df":9,"docs":{"10":{"tf":1.0},"26":{"tf":2.23606797749979},"32":{"tf":2.6457513110645907},"34":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"49":{"tf":1.0},"7":{"tf":2.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}},"t":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"c":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":2,"docs":{"115":{"tf":1.0},"116":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"f":{"c":{"df":2,"docs":{"53":{"tf":1.0},"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},".":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}}},"_":{"1":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"81":{"tf":1.0}}},"2":{"df":1,"docs":{"82":{"tf":1.0}}},"3":{"df":1,"docs":{"83":{"tf":1.0}}},"4":{"df":1,"docs":{"84":{"tf":1.0}}},"[":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":2,"docs":{"100":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"1":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}},"2":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":5,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},".":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"v":{"c":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":84,"docs":{"0":{"tf":2.6457513110645907},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"100":{"tf":1.0},"101":{"tf":1.0},"11":{"tf":2.23606797749979},"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"14":{"tf":2.0},"15":{"tf":2.23606797749979},"16":{"tf":2.449489742783178},"17":{"tf":2.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"23":{"tf":2.8284271247461903},"24":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.8284271247461903},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"4":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"87":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":12,"docs":{"102":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":2.0},"117":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":2.0},"37":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"12":{"tf":2.6457513110645907},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"27":{"tf":1.0},"29":{"tf":2.0},"56":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"38":{"tf":1.0},"48":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"44":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"42":{"tf":2.449489742783178},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":4.69041575982343},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"81":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"i":{"d":{"df":4,"docs":{"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0}}}},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":32,"docs":{"0":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"26":{"tf":2.0},"30":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"56":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"19":{"tf":2.6457513110645907},"26":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":8,"docs":{"100":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":3.605551275463989},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":1,"docs":{"82":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":7,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"34":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"83":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":2.23606797749979}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"121":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"m":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"66":{"tf":2.23606797749979},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":3.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"86":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"11":{"tf":1.0}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"4":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"26":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":6,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"56":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}},"r":{"df":5,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"29":{"tf":2.0},"56":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":2.23606797749979},"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"118":{"tf":1.0},"120":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"86":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.7320508075688772},"126":{"tf":2.0},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":1,"docs":{"11":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":12,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0}}}}}}}}}},"p":{"_":{"c":{"df":1,"docs":{"82":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"43":{"tf":1.0}},"f":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":2.23606797749979},"92":{"tf":1.0},"93":{"tf":2.23606797749979}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"26":{"tf":2.23606797749979},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"l":{"df":1,"docs":{"82":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"98":{"tf":1.0},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"[":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"5":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"u":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"48":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":26,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":5,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"43":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":4.123105625617661}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":2.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"96":{"tf":3.7416573867739413}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":9,"docs":{"100":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"86":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"124":{"tf":1.0},"126":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"41":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":1.4142135623730951},"90":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951},"96":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"s":{"_":{"d":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}},"e":{"1":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"2":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":9,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":9,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"[":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"r":{"1":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":1.7320508075688772},"81":{"tf":1.0}},"e":{"df":1,"docs":{"100":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"6":{"tf":1.0}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"41":{"tf":2.23606797749979},"78":{"tf":2.6457513110645907},"79":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"42":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"65":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"6":{"tf":1.0}},"t":{"df":3,"docs":{"103":{"tf":2.0},"104":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":10,"docs":{"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"_":{"d":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"[":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":28,"docs":{"0":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":2.23606797749979},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":2.449489742783178},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":2.449489742783178},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.7320508075688772},"46":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"1":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"32":{"tf":1.0},"73":{"tf":1.0}}}}},"df":2,"docs":{"121":{"tf":1.0},"122":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"d":{"df":7,"docs":{"56":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"27":{"tf":2.0},"29":{"tf":3.4641016151377544},"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"41":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"51":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"43":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":2.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"74":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"23":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"121":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}},"u":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":44,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":12,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}}}},"i":{"b":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"101":{"tf":1.0}}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"83":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":4,"docs":{"15":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"36":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"40":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"59":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"df":7,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}}},"t":{"df":12,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":2.8284271247461903},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}},"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"19":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":2.449489742783178},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":5,"docs":{"100":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"a":{"_":{"df":0,"docs":{},"{":{"1":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"2":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"3":{"1":{"df":1,"docs":{"22":{"tf":1.0}}},"2":{"df":1,"docs":{"22":{"tf":1.0}}},"3":{"df":1,"docs":{"22":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"0":{"df":5,"docs":{"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"37":{"tf":2.0}}},"1":{"df":3,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":2.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":2.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}},"x":{"df":1,"docs":{"65":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"95":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772}}}},"df":4,"docs":{"56":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0}}},"w":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":3.0},"11":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":2.449489742783178}}}},"v":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":7,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"26":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"0":{"tf":1.0},"121":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"26":{"tf":2.6457513110645907},"30":{"tf":1.0},"56":{"tf":2.0},"62":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"11":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"9":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"e":{"df":15,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":2.8284271247461903},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":2.6457513110645907},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":2.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"i":{"c":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"[":{"6":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}},"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}},"p":{"df":11,"docs":{"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":2.449489742783178}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"b":{"df":0,"docs":{},"f":{"a":{"c":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}},"df":5,"docs":{"27":{"tf":2.23606797749979},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"42":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}},"df":14,"docs":{"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"124":{"tf":1.0},"126":{"tf":2.0},"26":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{">":{">":{">":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.8284271247461903},"86":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"[":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"1":{"df":1,"docs":{"41":{"tf":1.0}}},"2":{"df":1,"docs":{"41":{"tf":1.0}}},"3":{"df":1,"docs":{"41":{"tf":1.0}}},"4":{"df":1,"docs":{"41":{"tf":1.0}}},"5":{"df":1,"docs":{"41":{"tf":1.0}}},"6":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}}}},"df":15,"docs":{"108":{"tf":2.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":2.0},"125":{"tf":1.0},"126":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"41":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"67":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"27":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":27,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.0},"61":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.0}}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"68":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":10,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"m":{"(":{"a":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"s":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"f":{"a":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"21":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"t":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"a":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":5,"docs":{"100":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":11,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"121":{"tf":2.0},"123":{"tf":2.23606797749979},"125":{"tf":2.8284271247461903},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"65":{"tf":1.0}}},"df":22,"docs":{"101":{"tf":2.0},"102":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.7320508075688772},"121":{"tf":2.0},"122":{"tf":1.7320508075688772},"124":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.0},"22":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":2.8284271247461903}}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"34":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"df":11,"docs":{"48":{"tf":1.0},"56":{"tf":2.8284271247461903},"57":{"tf":2.6457513110645907},"58":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"61":{"tf":1.4142135623730951},"64":{"tf":2.0},"65":{"tf":2.23606797749979},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"96":{"tf":3.872983346207417}},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"x":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"84":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}},"i":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.0},"96":{"tf":2.6457513110645907}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"p":{"df":1,"docs":{"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"121":{"tf":2.0},"122":{"tf":1.7320508075688772}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"34":{"tf":1.0}}}}},"t":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"38":{"tf":1.0},"52":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":11,"docs":{"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":11,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"52":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"64":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":45,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":2.6457513110645907},"30":{"tf":2.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.449489742783178},"93":{"tf":2.23606797749979},"96":{"tf":3.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"u":{"b":{"b":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":22,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":3.1622776601683795},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":2.0},"83":{"tf":2.0},"84":{"tf":2.0},"87":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":6,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":15,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"27":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"45":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"56":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":12,"docs":{"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"29":{"tf":3.4641016151377544},"41":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":25,"docs":{"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":3.1622776601683795},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"42":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":2.6457513110645907},"90":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":2.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":5,"docs":{"104":{"tf":1.7320508075688772},"26":{"tf":1.0},"41":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":2.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":21,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"78":{"tf":1.0},"90":{"tf":2.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"n":{"df":4,"docs":{"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"y":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"3":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.7320508075688772},"64":{"tf":1.0},"74":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"19":{"tf":2.0}}}}}}}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"100":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}}},"x":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":5,"docs":{"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}},"i":{"df":3,"docs":{"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"y":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":1,"docs":{"50":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.7320508075688772},"81":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"title":{"root":{"1":{"df":1,"docs":{"123":{"tf":1.0}}},"2":{"df":1,"docs":{"125":{"tf":1.0}}},"3":{"df":0,"docs":{},"x":{"3":{"df":2,"docs":{"115":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"22":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"100":{"tf":1.0},"85":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"100":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"72":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"23":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":3,"docs":{"39":{"tf":1.0},"42":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"u":{"d":{"a":{"df":5,"docs":{"100":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"118":{"tf":1.0},"69":{"tf":1.0}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"30":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"a":{"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":7,"docs":{"18":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"48":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}}}}}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"67":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"72":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"42":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"123":{"tf":1.0},"125":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"47":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"22":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.0},"63":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":6,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"107":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0}}}}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"66":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"123":{"tf":1.0},"125":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"108":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"4":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"101":{"tf":1.0},"121":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"65":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":3,"docs":{"18":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"88":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"91":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"123":{"tf":1.0},"125":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});