#include "gpu_error.h"


void print_error(cudaError_t err, const char* file, int line)
{
    fprintf(stderr, " CUDA error in file <%s>, line %d : %s [code %d].\n", file, line, cudaGetErrorString(err), err);
    fflush(stderr);
    exit(1);
}

void kernel_error_check(cudaStream_t stream, const char* file, int line)
{
    int pos = 0;

#ifdef WIN64
    // VC++ outputs __FILE__ with backslashes
    std::string filename = std::string(file);
    pos = static_cast<int>(filename.rfind('\\'));
    pos = (pos == -1) ? static_cast<int>(filename.rfind('/')) + 1 : pos + 1;
#endif

    // Check kernel configuration error
    cudaError_t err = cudaGetLastError();
    if (err != cudaSuccess) {
        print_error(err, file + pos, line);
    }

    // Check general CUDA error
    err = cudaStreamSynchronize(stream);
    if (err != cudaSuccess) {
        print_error(err, file + pos, line);
    }
}
