#include "interface.h"
#include "mat_metal.h"
#include "mat_concrete.h"
#include "mat_rubber.h"
#include "mat_orthotropic.h"
#include "mat_glass.h"

user_metal::MatMetal metal;
user_concrete::MatConcrete concrete;
user_rubber::MatRubber rubber;
user_orthotropic::MatOrthotropic orthotropic;
user_glass::MatGlass glass;

//-------------------------------------------------------------------------------------------------
//
// Call to user material 1 (metal example)
//
//-------------------------------------------------------------------------------------------------

void mat_user_1_config(UserMatConfig* config, UserMatProp* properties)
{
    metal.getConfig(config, properties);
}

void init_mat_user_1(UserMatInitCPU data)
{
    metal.runInit(data);
}

void mat_user_1(UserMatCPU data)
{
    metal.runMat(data);
}

void init_mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    metal.runInitGPU(host, device, stream);
}

void mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    metal.runMatGPU(host, device, stream);
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 2 (concrete example)
//
//-------------------------------------------------------------------------------------------------

void mat_user_2_config(UserMatConfig* config, UserMatProp* properties)
{
    concrete.getConfig(config, properties);
}

void init_mat_user_2(UserMatInitCPU data)
{
    concrete.runInit(data);
}

void mat_user_2(UserMatCPU data)
{
    concrete.runMat(data);
}

void init_mat_user_2_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    concrete.runInitGPU(host, device, stream);
}

void mat_user_2_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    concrete.runMatGPU(host, device, stream);
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 3 (rubber example)
//
//-------------------------------------------------------------------------------------------------

void mat_user_3_config(UserMatConfig* config, UserMatProp* properties)
{
    rubber.getConfig(config, properties);
}

void init_mat_user_3(UserMatInitCPU data)
{
    rubber.runInit(data);
}

void mat_user_3(UserMatCPU data)
{
    rubber.runMat(data);
}

void init_mat_user_3_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    rubber.runInitGPU(host, device, stream);
}

void mat_user_3_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    rubber.runMatGPU(host, device, stream);
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 4 (orthotropic example)
//
//-------------------------------------------------------------------------------------------------

void mat_user_4_config(UserMatConfig* config, UserMatProp* properties)
{
    orthotropic.getConfig(config, properties);
}

void init_mat_user_4(UserMatInitCPU data)
{
    orthotropic.runInit(data);
}

void mat_user_4(UserMatCPU data)
{
    orthotropic.runMat(data);
}

void init_mat_user_4_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    orthotropic.runInitGPU(host, device, stream);
}

void mat_user_4_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    orthotropic.runMatGPU(host, device, stream);
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 5
//
//-------------------------------------------------------------------------------------------------

void mat_user_5_config(UserMatConfig* config, UserMatProp* properties)
{
    glass.getConfig(config, properties);
}

void init_mat_user_5(UserMatInitCPU data)
{
    glass.runInit(data);
}

void mat_user_5(UserMatCPU data)
{
    glass.runMat(data);
}

void init_mat_user_5_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    glass.runInitGPU(host, device, stream);
}

void mat_user_5_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
    glass.runMatGPU(host, device, stream);
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 6
//
//-------------------------------------------------------------------------------------------------

void mat_user_6_config(UserMatConfig* config, UserMatProp* properties)
{
}

void init_mat_user_6(UserMatInitCPU data)
{
}

void mat_user_6(UserMatCPU data)
{
}

void init_mat_user_6_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}

void mat_user_6_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 7
//
//-------------------------------------------------------------------------------------------------

void mat_user_7_config(UserMatConfig* config, UserMatProp* properties)
{
}

void init_mat_user_7(UserMatInitCPU data)
{
}

void mat_user_7(UserMatCPU data)
{
}

void init_mat_user_7_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}

void mat_user_7_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}

//-------------------------------------------------------------------------------------------------
//
// Call to user material 8
//
//-------------------------------------------------------------------------------------------------

void mat_user_8_config(UserMatConfig* config, UserMatProp* properties)
{
}

void init_mat_user_8(UserMatInitCPU data)
{
}

void mat_user_8(UserMatCPU data)
{
}

void runInitGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}

void mat_user_8_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream)
{
}
