#ifndef INTERFACE_H_
#define INTERFACE_H_

#include "mat_user_defines.h"

#ifdef _WIN64
#define DLL_EXPORT __declspec(dllexport)
#else
#define DLL_EXPORT
#endif

extern "C" {

DLL_EXPORT void mat_user_1_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_2_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_3_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_4_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_5_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_6_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_7_config(UserMatConfig* config, UserMatProp* properties);
DLL_EXPORT void mat_user_8_config(UserMatConfig* config, UserMatProp* properties);

DLL_EXPORT void init_mat_user_1(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_2(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_3(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_4(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_5(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_6(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_7(UserMatInitCPU data);
DLL_EXPORT void init_mat_user_8(UserMatInitCPU data);

DLL_EXPORT void mat_user_1(UserMatCPU data);
DLL_EXPORT void mat_user_2(UserMatCPU data);
DLL_EXPORT void mat_user_3(UserMatCPU data);
DLL_EXPORT void mat_user_4(UserMatCPU data);
DLL_EXPORT void mat_user_5(UserMatCPU data);
DLL_EXPORT void mat_user_6(UserMatCPU data);
DLL_EXPORT void mat_user_7(UserMatCPU data);
DLL_EXPORT void mat_user_8(UserMatCPU data);

DLL_EXPORT void init_mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_2_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_3_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_4_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_5_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_6_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_7_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void init_mat_user_8_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);

DLL_EXPORT void mat_user_1_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_2_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_3_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_4_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_5_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_6_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_7_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);
DLL_EXPORT void mat_user_8_gpu(UserMatHost host, UserMatDevice device, cudaStream_t stream);

} // extern "C"


#endif // INTERFACE_H_
