#ifndef MAT_GLASS_H_
#define MAT_GLASS_H_

#include "mat_user.h"
#include <unordered_map>
#include <vector>
#include <utility>
#include <cstdlib>

namespace user_glass
{
// Define the Flaw struct
struct Flaw {
    double depth;
    double length;
    double orientation[3];
};

// Define a custom hash function for std::pair<int, int>
struct PairHash {
    std::size_t operator()(const std::pair<int, int>& pair) const {
        return std::hash<int>()(pair.first) ^ (std::hash<int>()(pair.second) << 1);
    }
};

class MatGlass : public MatUser {
  public:
    MatGlass();

    void runInit(UserMatInitCPU data) const override;
    void runMat(UserMatCPU data) const override;

    void runInitGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const override;
    void runMatGPU(UserMatHost host, UserMatDevice device, cudaStream_t stream) const override;

  private:
    mutable std::unordered_map<std::pair<int, int>, std::vector<Flaw>, PairHash> flaw_map;
};

} // namespace user_glass

#endif // MAT_GLASS_H_
